/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.util;

import java.util.List;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;

public class ClassImportIntegrator
implements Integrator {
    private static final String DOT = ".";
    private final List<? extends Class> classImportList;
    private String excludedPath;

    public ClassImportIntegrator(List<? extends Class> classImportList) {
        this.classImportList = classImportList;
    }

    public ClassImportIntegrator excludePath(String path) {
        this.excludedPath = path.endsWith(DOT) ? path : path + DOT;
        return this;
    }

    public void integrate(Metadata metadata, BootstrapContext bootstrapContext, SessionFactoryImplementor sessionFactory) {
        for (Class clazz : this.classImportList) {
            String key = this.excludedPath != null ? clazz.getName().replace(this.excludedPath, "") : clazz.getSimpleName();
            metadata.getImports().put(key, clazz.getName());
        }
    }

    public void disintegrate(SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
    }
}

