/*
 * Decompiled with CFR 0.152.
 */
package io.hypertrack.smart_scheduler;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import io.hypertrack.smart_scheduler.SmartScheduler;

public class Job {
    private final int jobId;
    private final int jobType;
    private final SmartScheduler.JobScheduledCallback jobScheduledCallback;
    private final String periodicTaskTag;
    private final boolean requireCharging;
    private final int networkType;
    private final boolean isPeriodic;
    private final long intervalMillis;
    private final long initialDelayInMillis;
    private final Long flexInMillis;
    protected static final long JOB_TYPE_HANDLER_THRESHOLD = 60000L;

    public static int generateJobID() {
        return (int)(System.currentTimeMillis() / 1000L);
    }

    public int getJobId() {
        return this.jobId;
    }

    public int getJobType() {
        return this.jobType;
    }

    public SmartScheduler.JobScheduledCallback getJobScheduledCallback() {
        return this.jobScheduledCallback;
    }

    public String getPeriodicTaskTag() {
        return this.periodicTaskTag;
    }

    public boolean getRequiresCharging() {
        return this.requireCharging;
    }

    public int getNetworkType() {
        return this.networkType;
    }

    public boolean isPeriodic() {
        return this.isPeriodic;
    }

    public long getIntervalMillis() {
        return this.intervalMillis;
    }

    public long getInitialDelayInMillis() {
        return this.initialDelayInMillis;
    }

    public Long getFlexInMillis() {
        return this.flexInMillis;
    }

    private Job(Builder b) {
        this.jobId = b.mJobId;
        this.jobType = b.mJobType;
        this.jobScheduledCallback = b.mJobScheduledCallback;
        this.periodicTaskTag = b.mPeriodicTaskTag;
        this.requireCharging = b.mRequiresCharging;
        this.networkType = b.mNetworkType;
        this.isPeriodic = b.mIsPeriodic;
        this.intervalMillis = b.mIntervalMillis;
        this.initialDelayInMillis = b.mInitialDelayInMillis;
        this.flexInMillis = b.mFlexInMillis;
    }

    public String toString() {
        return "Job{jobId=" + this.jobId + ", jobType=" + this.jobType + ", jobScheduledCallback=" + (this.jobScheduledCallback != null ? this.jobScheduledCallback : " null") + ", periodicTaskTag='" + (this.periodicTaskTag != null ? this.periodicTaskTag : " null") + ", requireCharging=" + this.requireCharging + ", networkType=" + this.networkType + ", isPeriodic=" + this.isPeriodic + ", intervalMillis=" + this.intervalMillis + ", initialDelayInMillis=" + this.initialDelayInMillis + ", flexInMillis=" + (this.flexInMillis != null ? this.flexInMillis : " null") + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Job job = (Job)o;
        if (this.jobId != job.jobId) {
            return false;
        }
        if (this.jobType != job.jobType) {
            return false;
        }
        if (this.requireCharging != job.requireCharging) {
            return false;
        }
        if (this.networkType != job.networkType) {
            return false;
        }
        if (this.isPeriodic != job.isPeriodic) {
            return false;
        }
        if (this.intervalMillis != job.intervalMillis) {
            return false;
        }
        if (this.initialDelayInMillis != job.initialDelayInMillis) {
            return false;
        }
        if (!this.jobScheduledCallback.equals(job.jobScheduledCallback)) {
            return false;
        }
        return this.periodicTaskTag.equals(job.periodicTaskTag);
    }

    public int hashCode() {
        int result = this.jobId;
        result = 31 * result + this.jobType;
        result = 31 * result + this.jobScheduledCallback.hashCode();
        result = 31 * result + this.periodicTaskTag.hashCode();
        result = 31 * result + (this.requireCharging ? 1 : 0);
        result = 31 * result + this.networkType;
        result = 31 * result + (this.isPeriodic ? 1 : 0);
        result = 31 * result + (int)(this.intervalMillis ^ this.intervalMillis >>> 32);
        result = 31 * result + (int)(this.initialDelayInMillis ^ this.initialDelayInMillis >>> 32);
        return result;
    }

    public static final class Builder {
        private int mJobId;
        private int mJobType = 0;
        private SmartScheduler.JobScheduledCallback mJobScheduledCallback;
        private String mPeriodicTaskTag;
        private boolean mRequiresCharging = false;
        private int mNetworkType = 2;
        private long mIntervalMillis = 60000L;
        private boolean mIsPeriodic = false;
        private long mInitialDelayInMillis = 60000L;
        private Long mFlexInMillis = null;

        public Builder(SmartScheduler.JobScheduledCallback jobScheduledCallback, @NonNull String periodicTaskTag) {
            Job.generateJobID();
            this.mJobScheduledCallback = jobScheduledCallback;
            this.mPeriodicTaskTag = periodicTaskTag;
        }

        public Builder(SmartScheduler.JobScheduledCallback jobScheduledCallback, int jobType, @Nullable String periodicTaskTag) {
            Job.generateJobID();
            this.mJobScheduledCallback = jobScheduledCallback;
            this.mPeriodicTaskTag = periodicTaskTag;
            this.mJobType = jobType;
        }

        public Builder(int jobId, SmartScheduler.JobScheduledCallback jobScheduledCallback, @NonNull String periodicTaskTag) {
            this.mJobScheduledCallback = jobScheduledCallback;
            this.mPeriodicTaskTag = periodicTaskTag;
            this.mJobId = jobId;
        }

        public Builder(int jobId, SmartScheduler.JobScheduledCallback jobScheduledCallback, int jobType, @Nullable String periodicTaskTag) {
            this.mJobScheduledCallback = jobScheduledCallback;
            this.mPeriodicTaskTag = periodicTaskTag;
            this.mJobType = jobType;
            this.mJobId = jobId;
        }

        public Builder setPeriodicTaskTag(String periodicTaskTag) {
            this.mPeriodicTaskTag = periodicTaskTag;
            return this;
        }

        public Builder setRequiredNetworkType(int networkType) {
            this.mNetworkType = networkType;
            return this;
        }

        public Builder setRequiresCharging(boolean requiresCharging) {
            this.mRequiresCharging = requiresCharging;
            return this;
        }

        public Builder setIntervalMillis(long intervalMillis) {
            this.mIsPeriodic = false;
            this.mIntervalMillis = intervalMillis;
            return this;
        }

        public Builder setFlex(long flexInMillis) {
            this.mFlexInMillis = flexInMillis;
            return this;
        }

        public Builder setPeriodic(long intervalMillis) {
            this.mIsPeriodic = true;
            this.mIntervalMillis = intervalMillis;
            this.mInitialDelayInMillis = intervalMillis;
            return this;
        }

        public Builder setPeriodic(long intervalMillis, long initialDelayInMillis) {
            this.mIsPeriodic = true;
            this.mIntervalMillis = intervalMillis;
            this.mInitialDelayInMillis = initialDelayInMillis;
            return this;
        }

        public Job build() {
            if (this.mJobType == 0) {
                this.mJobType = this.mIntervalMillis < 60000L ? 1 : (this.mRequiresCharging || this.mNetworkType != 2 ? 2 : 3);
            }
            return new Job(this);
        }
    }

    public abstract class Type {
        public static final int JOB_TYPE_NONE = 0;
        public static final int JOB_TYPE_HANDLER = 1;
        public static final int JOB_TYPE_PERIODIC_TASK = 2;
        public static final int JOB_TYPE_ALARM = 3;
    }

    public abstract class NetworkType {
        public static final int NETWORK_TYPE_ANY = 2;
        public static final int NETWORK_TYPE_CONNECTED = 0;
        public static final int NETWORK_TYPE_UNMETERED = 1;
    }
}

