/*
 * Decompiled with CFR 0.152.
 */
package io.hypertrack.smart_scheduler;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.google.android.gms.gcm.GcmNetworkManager;
import com.google.android.gms.gcm.OneoffTask;
import com.google.android.gms.gcm.PeriodicTask;
import com.google.android.gms.gcm.Task;
import io.hypertrack.smart_scheduler.Job;
import io.hypertrack.smart_scheduler.SmartSchedulerAlarmReceiver;
import io.hypertrack.smart_scheduler.SmartSchedulerPeriodicTaskService;
import io.hypertrack.smart_scheduler.Utils;
import java.io.Serializable;
import java.util.Calendar;
import java.util.HashMap;

public class SmartScheduler {
    private static final String TAG = SmartScheduler.class.getSimpleName();
    public static final String ALARM_JOB_ID_KEY = "io.hypertrack.android_scheduler:AlarmJobID";
    public static final String PERIODIC_TASK_JOB_ID_KEY = "io.hypertrack.android_scheduler:PeriodicTaskJobID";
    private static SmartScheduler smartScheduler;
    private Context mContext;
    private HashMap<Integer, Job> scheduledJobs;
    private HashMap<Integer, Handler> jobHandlers;
    private HashMap<Integer, Runnable> jobRunnables;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SmartScheduler getInstance(Context context) {
        if (smartScheduler != null) return smartScheduler;
        Class<SmartScheduler> clazz = SmartScheduler.class;
        synchronized (SmartScheduler.class) {
            if (smartScheduler != null) return smartScheduler;
            smartScheduler = new SmartScheduler(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return smartScheduler;
        }
    }

    private SmartScheduler(Context context) {
        this.mContext = context;
        this.scheduledJobs = new HashMap();
        this.jobHandlers = new HashMap();
        this.jobRunnables = new HashMap();
    }

    public Job get(int jobId) {
        return this.scheduledJobs.get(jobId);
    }

    public boolean contains(int jobId) {
        return this.scheduledJobs.containsKey(jobId);
    }

    public boolean contains(Job job) {
        return this.scheduledJobs.containsValue(job);
    }

    public boolean addJob(Job job) {
        if (job == null || job.getJobId() <= 0 || job.getJobScheduledCallback() == null) {
            return false;
        }
        boolean result = false;
        this.removeJob(job.getJobId());
        switch (job.getJobType()) {
            case 1: {
                result = this.addHandlerJob(job);
                break;
            }
            case 2: {
                if (Utils.checkIfPowerSaverModeEnabled(this.mContext)) {
                    result = this.addAlarmJob(job);
                    break;
                }
                result = this.addPeriodicTaskJob(job);
                break;
            }
            case 3: {
                result = this.addAlarmJob(job);
                break;
            }
            default: {
                Log.e((String)TAG, (String)"Error occurred while addJob: JobType is INVALID");
            }
        }
        if (result) {
            this.scheduledJobs.put(job.getJobId(), job);
        }
        return result;
    }

    public boolean removeJob(int jobId) {
        this.removeHandlerJob(jobId);
        this.removeAlarmJob(jobId);
        if (this.scheduledJobs != null && this.scheduledJobs.get(jobId) != null) {
            this.removePeriodicTaskJob(this.scheduledJobs.get(jobId).getPeriodicTaskTag());
            this.scheduledJobs.remove(jobId);
            return true;
        }
        return false;
    }

    private boolean isJobValid(Job job) {
        try {
            if (!(job == null || this.scheduledJobs.get(job.getJobId()) == null || Utils.checkIfPowerSaverModeEnabled(this.mContext) && this.scheduledJobs.get(job.getJobId()).getJobType() != job.getJobType() || this.scheduledJobs.get(job.getJobId()).getIntervalMillis() != job.getIntervalMillis())) {
                return true;
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Exception occurred while isJobValid: " + e));
            return false;
        }
        Log.e((String)TAG, (String)("Job not valid: " + job));
        return false;
    }

    private void onJobScheduled(Job job) {
        if (job == null) {
            return;
        }
        if (!this.isJobValid(job)) {
            this.removeJob(job.getJobId());
            return;
        }
        if (job.getRequiresCharging() && !this.isCharging()) {
            return;
        }
        if (job.getNetworkType() == 0 && !this.isConnected()) {
            return;
        }
        if (job.getNetworkType() == 1 && !this.isConnected() && !this.isConnectionUnMetered()) {
            return;
        }
        job.getJobScheduledCallback().onJobScheduled(this.mContext, job);
        if (!job.isPeriodic()) {
            this.removeJob(job.getJobId());
        }
    }

    public void onHandlerJobScheduled(int jobID) {
        if (this.scheduledJobs != null && this.scheduledJobs.get(jobID) != null) {
            this.onJobScheduled(this.scheduledJobs.get(jobID));
            return;
        }
        this.removeHandlerJob(jobID);
    }

    public void onAlarmJobScheduled(int jobID) {
        if (this.scheduledJobs != null && this.scheduledJobs.get(jobID) != null) {
            this.onJobScheduled(this.scheduledJobs.get(jobID));
            return;
        }
        this.removeAlarmJob(jobID);
    }

    public void onPeriodicTaskJobScheduled(String periodicTaskTag, Bundle bundle) {
        try {
            if (bundle == null) {
                return;
            }
            int jobID = bundle.getInt(PERIODIC_TASK_JOB_ID_KEY);
            if (this.scheduledJobs != null && this.scheduledJobs.get(jobID) != null) {
                this.onJobScheduled(this.scheduledJobs.get(jobID));
                return;
            }
            this.removePeriodicTaskJob(periodicTaskTag);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Exception occurred while onPeriodicTaskJobScheduled: " + e));
        }
    }

    public void onPowerSaverModeChanged(boolean powerSaverModeEnabled) {
        Log.i((String)TAG, (String)("SmartScheduler onPowerSaverModeChanged: " + powerSaverModeEnabled));
        if (this.scheduledJobs != null && this.scheduledJobs.size() > 0) {
            for (int jobID : this.scheduledJobs.keySet()) {
                Job job = this.scheduledJobs.get(jobID);
                if (job == null || job.getJobType() != 2) continue;
                this.removeJob(jobID);
                this.updateJobsOnPowerSaverModeChanged(job, powerSaverModeEnabled);
            }
        }
    }

    private boolean updateJobsOnPowerSaverModeChanged(Job job, boolean powerSaverModeEnabled) {
        if (powerSaverModeEnabled) {
            if (job.getIntervalMillis() < 60000L) {
                return this.addHandlerJob(job);
            }
            return this.addAlarmJob(job);
        }
        return this.addPeriodicTaskJob(job);
    }

    private boolean addHandlerJob(final Job job) {
        if (job == null) {
            return false;
        }
        final int jobID = job.getJobId();
        this.removeHandlerJob(jobID);
        this.jobRunnables.put(jobID, new Runnable(){

            @Override
            public void run() {
                try {
                    SmartScheduler.this.onHandlerJobScheduled(job.getJobId());
                    if (!SmartScheduler.this.isJobValid(job)) {
                        return;
                    }
                    if (job.isPeriodic() && SmartScheduler.this.jobHandlers.get(jobID) != null && SmartScheduler.this.jobRunnables.get(jobID) != null) {
                        ((Handler)SmartScheduler.this.jobHandlers.get(jobID)).postDelayed((Runnable)SmartScheduler.this.jobRunnables.get(jobID), job.getIntervalMillis());
                    }
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)("Exception occurred while HandlerTypeJob.onRun(): " + e));
                }
            }
        });
        this.initializeJobHandler(jobID);
        this.jobHandlers.get(jobID).post(this.jobRunnables.get(jobID));
        Log.i((String)TAG, (String)("Handler Job: " + job + " scheduled to run after " + job.getIntervalMillis() + "ms"));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initializeJobHandler(int jobID) {
        if (this.jobHandlers.get(jobID) != null) return;
        Class<SmartScheduler> clazz = SmartScheduler.class;
        synchronized (SmartScheduler.class) {
            if (this.jobHandlers.get(jobID) != null) return;
            if (Looper.myLooper() == null) {
                Looper.prepare();
            }
            this.jobHandlers.put(jobID, new Handler(Looper.myLooper()));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private boolean addPeriodicTaskJob(Job job) {
        try {
            Job existingJob;
            if (job == null) {
                return false;
            }
            if (this.scheduledJobs != null && (existingJob = this.scheduledJobs.get(job.getJobId())) != null && !existingJob.getPeriodicTaskTag().equalsIgnoreCase(job.getPeriodicTaskTag())) {
                this.removePeriodicTaskJob(existingJob.getPeriodicTaskTag());
            }
            Bundle bundle = new Bundle();
            bundle.putInt(PERIODIC_TASK_JOB_ID_KEY, job.getJobId());
            if (job.isPeriodic()) {
                PeriodicTask task = new PeriodicTask.Builder().setExtras(bundle).setService(SmartSchedulerPeriodicTaskService.class).setPeriod(job.getIntervalMillis() / 1000L).setRequiredNetwork(job.getNetworkType()).setRequiresCharging(job.getRequiresCharging()).setPersisted(true).setTag(job.getPeriodicTaskTag()).setUpdateCurrent(true).build();
                GcmNetworkManager.getInstance((Context)this.mContext).schedule((Task)task);
                Log.i((String)TAG, (String)("PeriodicTask job: " + job + " scheduled to run at " + job.getIntervalMillis() + "ms interval"));
            } else {
                OneoffTask task = new OneoffTask.Builder().setExtras(bundle).setService(SmartSchedulerPeriodicTaskService.class).setTag(job.getPeriodicTaskTag()).setExecutionWindow(0L, job.getIntervalMillis() / 1000L).setRequiredNetwork(job.getNetworkType()).setRequiresCharging(job.getRequiresCharging()).setPersisted(true).setUpdateCurrent(true).build();
                GcmNetworkManager.getInstance((Context)this.mContext).schedule((Task)task);
                Log.i((String)TAG, (String)("OneoffTask job: " + job + " scheduled to run after " + job.getIntervalMillis() + "ms"));
            }
            return true;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Exception occurred while addPeriodicTaskJob: " + e));
            return false;
        }
    }

    private boolean addAlarmJob(Job job) {
        try {
            Bundle bundle = new Bundle();
            bundle.putInt(ALARM_JOB_ID_KEY, job.getJobId());
            Intent intent = new Intent(this.mContext, SmartSchedulerAlarmReceiver.class);
            intent.putExtras(bundle);
            PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)job.getJobId(), (Intent)intent, (int)0x8000000);
            Calendar calendar = Calendar.getInstance();
            AlarmManager alarm = (AlarmManager)this.mContext.getSystemService("alarm");
            if (job.isPeriodic()) {
                alarm.setRepeating(0, calendar.getTimeInMillis(), job.getIntervalMillis(), pendingIntent);
                Log.i((String)TAG, (String)("RepeatingAlarm job: " + job + " scheduled to run at " + job.getIntervalMillis() + "ms interval"));
            } else {
                long triggerInMillis = calendar.getTimeInMillis() + job.getIntervalMillis();
                if (Build.VERSION.SDK_INT >= 23) {
                    alarm.setExactAndAllowWhileIdle(0, triggerInMillis, pendingIntent);
                } else if (Build.VERSION.SDK_INT >= 19) {
                    alarm.setExact(0, triggerInMillis, pendingIntent);
                } else {
                    alarm.set(0, triggerInMillis, pendingIntent);
                }
                Log.i((String)TAG, (String)("ExactAlarm job: " + job + " scheduled to run after " + job.getIntervalMillis() + "ms"));
            }
            return true;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Exception occurred while addAlarmJob: " + e));
            return false;
        }
    }

    private boolean removeHandlerJob(int jobID) {
        try {
            if (this.jobHandlers.get(jobID) != null) {
                this.jobHandlers.get(jobID).removeCallbacksAndMessages(null);
            }
            this.jobRunnables.remove(jobID);
            return true;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Exception occurred while removeHandlerJob: " + e));
            return false;
        }
    }

    private boolean removePeriodicTaskJob(String periodicTaskTag) {
        try {
            GcmNetworkManager.getInstance((Context)this.mContext).cancelTask(periodicTaskTag, SmartSchedulerPeriodicTaskService.class);
            return false;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Exception occurred while removePeriodicTaskJob: " + e));
            return false;
        }
    }

    private boolean removeAlarmJob(int jobID) {
        try {
            Intent intent = new Intent(this.mContext, SmartSchedulerAlarmReceiver.class);
            PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)jobID, (Intent)intent, (int)0);
            if (pendingIntent != null) {
                AlarmManager alarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
                alarmManager.cancel(pendingIntent);
            }
            return true;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Exception occurred while removeAlarmJob: " + e));
            return false;
        }
    }

    private boolean isCharging() {
        try {
            Intent batteryIntent = this.mContext.getApplicationContext().registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
            if (batteryIntent != null) {
                int batteryPowerStatus = batteryIntent.getIntExtra("status", 0);
                switch (batteryPowerStatus) {
                    case 2: 
                    case 5: {
                        return true;
                    }
                }
                return false;
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Exception occurred while isCharging: " + e));
        }
        return false;
    }

    private boolean isConnected() {
        ConnectivityManager cm = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
        return activeNetwork != null && activeNetwork.isConnectedOrConnecting();
    }

    private boolean isConnectionUnMetered() {
        ConnectivityManager cm = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        if (Build.VERSION.SDK_INT >= 16) {
            return !cm.isActiveNetworkMetered();
        }
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.getType() == 1;
    }

    public static interface JobScheduledCallback
    extends Serializable {
        public void onJobScheduled(Context var1, Job var2);
    }
}

