package io.hypertrack.lib.transmitter.model;

import io.hypertrack.lib.common.model.HTDriver;
import io.hypertrack.lib.common.model.HTPlace;

public class HTLiteParamsBuilder {

    private HTDriver driver;
    private HTPlace destination;

    public HTLiteParamsBuilder setDriver(HTDriver driver) {
        this.driver = driver;
        return this;
    }

    public HTLiteParamsBuilder setDestination(HTPlace destination) {
        this.destination = destination;
        return this;
    }

    public HTLiteParams createHTLiteParams() {
        return new HTLiteParams(driver, destination);
    }

}