package io.hypertrack.lib.transmitter.model;

import com.google.gson.annotations.SerializedName;

import java.util.Date;

import io.hypertrack.lib.common.model.HTLocation;

/**
 * Created by tapan on 22/03/16.
 */
public class HTShift {

    @SerializedName("id")
    private String id;

    @SerializedName("driver_id")
    private String driverID;

    @SerializedName("is_driver_live")
    private boolean isDriverActive;

    @SerializedName("is_active")
    private Boolean isActive;

    @SerializedName("start_location")
    private HTLocation startLocation;

    @SerializedName("end_location")
    private HTLocation endLocation;

    @SerializedName("started_at")
    private Date startedAt;

    @SerializedName("ended_at")
    private Date endedAt;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDriverID() {
        return driverID;
    }

    public void setDriverID(String driverID) {
        this.driverID = driverID;
    }

    public boolean isDriverActive() {
        return isDriverActive;
    }

    public void setDriverActive(boolean driverActive) {
        isDriverActive = driverActive;
    }

    public Boolean getActive() {
        return isActive;
    }

    public void setActive(Boolean active) {
        isActive = active;
    }

    public HTLocation getStartLocation() {
        return startLocation;
    }

    public void setStartLocation(HTLocation startLocation) {
        this.startLocation = startLocation;
    }

    public HTLocation getEndLocation() {
        return endLocation;
    }

    public void setEndLocation(HTLocation endLocation) {
        this.endLocation = endLocation;
    }

    public Date getStartedAt() {
        return startedAt;
    }

    public void setStartedAt(Date startedAt) {
        this.startedAt = startedAt;
    }

    public Date getEndedAt() {
        return endedAt;
    }

    public void setEndedAt(Date endedAt) {
        this.endedAt = endedAt;
    }

    @Override
    public String toString() {
        return "HTShift{" +
                "id='" + id + '\'' +
                ", driverID='" + (driverID != null ? driverID : "null") + '\'' +
                ", isDriverActive=" + isDriverActive +
                ", isActive=" + isActive +
                ", startLocation=" + startLocation +
                ", endLocation=" + endLocation +
                ", startedAt=" + startedAt +
                ", endedAt=" + endedAt +
                '}';
    }
}

