package io.hypertrack.lib.transmitter.model;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;

import io.hypertrack.lib.common.model.HTLocation;

public class HTShiftParams {

    @Expose(serialize = false, deserialize = false)
    private String shiftID;

    @SerializedName("start_location")
    private HTLocation startLocation;

    @SerializedName("driver_id")
    private String driverID;

    public String getShiftID() {
        return shiftID;
    }

    public void setShiftID(String shiftID) {
        this.shiftID = shiftID;
    }

    public HTLocation getStartLocation() {
        return startLocation;
    }

    public void setStartLocation(HTLocation startLocation) {
        this.startLocation = startLocation;
    }

    public String getDriverID() {
        return driverID;
    }

    /**
     * Sets ID of the driver.
     *
     * @param driverID
     */
    public void setDriverID(String driverID) {
        this.driverID = driverID;
    }

    public HTShiftParams(String driverID) {
        this.driverID = driverID;
    }

    @Override
    public String toString() {
        return "HTShiftParams{" +
                "startLocation=" + startLocation +
                ", shiftID=" + shiftID +
                ", driverID=" + driverID +
                '}';
    }
}
