package io.hypertrack.lib.transmitter.model;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;

import io.hypertrack.lib.common.model.HTDriverVehicleType;
import io.hypertrack.lib.common.model.HTLocation;

/**
 * Created by piyush on 14/07/16.
 */
public class HTTaskParams {

    @Expose(serialize = false, deserialize = false)
    private String taskID;

    @SerializedName("start_location")
    private HTLocation startLocation;

    @SerializedName("start_time")
    private String startTime = "";

    @SerializedName("driver_id")
    private String driverID;

    @SerializedName("vehicle_type")
    private HTDriverVehicleType vehicleType;

    public String getTaskID() {
        return taskID;
    }

    public void setTaskID(String taskID) {
        this.taskID = taskID;
    }

    public HTLocation getStartLocation() {
        return startLocation;
    }

    public void setStartLocation(HTLocation startLocation) {
        this.startLocation = startLocation;
    }

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getDriverID() {
        return driverID;
    }

    /**
     * Sets ID of the Driver.
     *
     * @param driverID
     */
    public void setDriverID(String driverID) {
        this.driverID = driverID;
    }

    public HTDriverVehicleType getVehicleType() {
        return vehicleType;
    }

    public void setVehicleType(HTDriverVehicleType vehicleType) {
        this.vehicleType = vehicleType;
    }

    private HTTaskParams(){
    }

    /**
     * Method to create an onject of HTTaskParams
     * <p>
     * NOTE: DriverID is an optional parameter. In case not provided, one will be generated
     * automatically and will be associated with this device.
     *
     * @param taskID        taskID to be tracked
     */
    public HTTaskParams(String taskID){
        this.taskID = taskID;
    }

    /**
     * Method to create an onject of HTTaskParams
     *
     * @param taskID        taskID to be tracked
     * @param driverID      ID of the current driver
     */
    public HTTaskParams(String taskID, String driverID) {
        this.taskID = taskID;
        this.driverID = driverID;
    }

    /**
     * Method to create an onject of HTTaskParams
     *
     * @param taskID        taskID to be tracked
     * @param driverID      ID of the current driver
     * @param vehicleType   Type of Vehicle for the current driver
     */
    public HTTaskParams(String taskID, String driverID, HTDriverVehicleType vehicleType) {
        this(taskID, driverID);
        this.vehicleType = vehicleType;
    }

    @Override
    public String toString() {
        return "HTTaskParams{" +
                "taskID=" + taskID +
                ", startLocation=" + startLocation +
                ", startTime=" + (startTime != null ? startTime.toString() : "") +
                ", driverID='" + driverID + '\'' +
                ", vehicleType=" + vehicleType +
                '}';
    }
}