package io.hypertrack.lib.transmitter.model;

import io.hypertrack.lib.common.model.HTDriverVehicleType;

/**
 * Created by piyush on 14/07/16.
 */
public class HTTaskParamsBuilder {

    private String taskID;
    private String driverID;
    private HTDriverVehicleType vehicleType;

    /**
     * Method to set the ID of the task which is going to be performed by the driver.
     * @param taskID
     * @return
     */
    public HTTaskParamsBuilder setTaskID(String taskID) {
        this.taskID = taskID;
        return this;
    }

    /**
     *The driverID is the id of the driver who will be tracked. Docs for this are available here:
     *https://4a266969b18b1589779c588e4d68948a92747dab.googledrive.com/host/0BxFwKXjNa3_Mfm1taG9vTUdkU3VfQ0tsZ0hnQmhKMDNrQUhGUEhkNUdfUmkxVUx1SnFzaUU/#couriers
     * @param driverID
     * @return
     */
    public HTTaskParamsBuilder setDriverID(String driverID) {
        this.driverID = driverID;
        return this;
    }

    public  HTTaskParamsBuilder setVehicleType(HTDriverVehicleType vehicleType) {
        this.vehicleType = vehicleType;
        return this;
    }

    /**
     *
     * @return
     */
    public HTTaskParams createHTTaskParams() {
        return new HTTaskParams(taskID, driverID, vehicleType);
    }
}