package io.hypertrack.lib.transmitter.model;

import com.google.gson.annotations.SerializedName;

import java.util.ArrayList;
import java.util.Date;

import io.hypertrack.lib.common.model.HTDriverVehicleType;
import io.hypertrack.lib.common.model.HTLocation;

/**
 * Created by ulhas on 12/03/16.
 */
public class HTTrip {

    @SerializedName("id")
    private String id;

    @SerializedName("driver_id")
    private String driverID;

    @SerializedName("is_live")
    private Boolean isLive;

    @SerializedName("initial_eta")
    private Date initialETA;

    @SerializedName("eta")
    private Date ETA;

    @SerializedName("status")
    private String status;

    @SerializedName("connection_status")
    private String connectionStatus;

    @SerializedName("distance")
    private Integer distance;

    @SerializedName("encoded_polyline")
    private String encodedPolyline;

    @SerializedName("time_aware_polyline")
    private String timeAwarePolyline;

    @SerializedName("start_location")
    private HTLocation startLocation;

    @SerializedName("end_location")
    private HTLocation endLocation;

    @SerializedName("started_at")
    private Date startedAt;

    @SerializedName("ended_at")
    private Date endedAt;

    @SerializedName("tasks")
    private ArrayList<String> taskIDs;

    @SerializedName("has_ordered_tasks")
    private boolean hasOrderedTasks;

    @SerializedName("vehicle_type")
    private HTDriverVehicleType vehicleType;

    @SerializedName("is_driver_live")
    private Boolean isDriverLive;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDriverID() {
        return driverID;
    }

    public void setDriverID(String driverID) {
        this.driverID = driverID;
    }

    public Boolean getLive() {
        return isLive;
    }

    public void setLive(Boolean live) {
        isLive = live;
    }

    public Date getInitialETA() {
        return initialETA;
    }

    public void setInitialETA(Date initialETA) {
        this.initialETA = initialETA;
    }

    public Date getETA() {
        return ETA;
    }

    public void setETA(Date ETA) {
        this.ETA = ETA;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getConnectionStatus() {
        return connectionStatus;
    }

    public void setConnectionStatus(String connectionStatus) {
        this.connectionStatus = connectionStatus;
    }

    public Integer getDistance() {
        return distance;
    }

    public void setDistance(Integer distance) {
        this.distance = distance;
    }

    public String getEncodedPolyline() {
        return encodedPolyline;
    }

    public void setEncodedPolyline(String encodedPolyline) {
        this.encodedPolyline = encodedPolyline;
    }

    public String getTimeAwarePolyline() {
        return timeAwarePolyline;
    }

    public void setTimeAwarePolyline(String timeAwarePolyline) {
        this.timeAwarePolyline = timeAwarePolyline;
    }

    public HTLocation getStartLocation() {
        return startLocation;
    }

    public void setStartLocation(HTLocation startLocation) {
        this.startLocation = startLocation;
    }

    public HTLocation getEndLocation() {
        return endLocation;
    }

    public void setEndLocation(HTLocation endLocation) {
        this.endLocation = endLocation;
    }

    public Date getStartedAt() {
        return startedAt;
    }

    public void setStartedAt(Date startedAt) {
        this.startedAt = startedAt;
    }

    public Date getEndedAt() {
        return endedAt;
    }

    public void setEndedAt(Date endedAt) {
        this.endedAt = endedAt;
    }

    public ArrayList<String> getTaskIDs() {
        return taskIDs;
    }

    public void setTaskIDs(ArrayList<String> taskIDs) {
        this.taskIDs = taskIDs;
    }

    public boolean hxasOrderedTasks() {
        return hasOrderedTasks;
    }

    public void setHasOrderedTasks(boolean hasOrderedTasks) {
        this.hasOrderedTasks = hasOrderedTasks;
    }

    public HTDriverVehicleType getVehicleType() {
        return vehicleType;
    }

    public void setVehicleType(HTDriverVehicleType vehicleType) {
        this.vehicleType = vehicleType;
    }

    public Boolean getIsDriverLive() {
        return isDriverLive;
    }

    public void setIsDriverLive(boolean isDriverLive) {
        this.isDriverLive = isDriverLive;
    }

    @Override
    public String toString() {
        return "HTTrip{" +
                "id='" + (id != null ? id : "") + '\'' +
                ", driverID='" + (driverID != null ? driverID : "") + '\'' +
                ", isLive=" + (isLive != null ? isLive : "") +
                ", initialETA=" + (initialETA != null ? initialETA : "") +
                ", ETA=" + (ETA != null ? ETA : "") +
                ", status='" + (status != null ? status : "") + '\'' +
                ", connectionStatus='" + (connectionStatus != null ? connectionStatus : "") + '\'' +
                ", distance=" + (distance != null ? distance : "") +
                ", encodedPolyline='" + (encodedPolyline != null ? encodedPolyline : "") + '\'' +
                ", timeAwarePolyline='" + (timeAwarePolyline != null ? timeAwarePolyline : "") + '\'' +
                ", startLocation=" + (startLocation != null ? startLocation : "") +
                ", endLocation=" + (endLocation != null ? endLocation : "") +
                ", startedAt=" + (startedAt != null ? startedAt : "") +
                ", endedAt=" + (endedAt != null ? endedAt : "") +
                ", taskIDs=" + (taskIDs != null ? taskIDs : "") +
                ", hasOrderedTasks=" + hasOrderedTasks +
                ", vehicleType=" + (vehicleType != null ? vehicleType : "") +
                ", isDriverLive=" + isDriverLive +
                '}';
    }
}
