package io.hypertrack.lib.transmitter.model;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;

import java.util.ArrayList;

import io.hypertrack.lib.common.model.HTLocation;
import io.hypertrack.lib.common.model.HTDriverVehicleType;

public class HTTripParams {

    @Expose(serialize = false, deserialize = false)
    private String tripID;

    @SerializedName("start_time")
    private String startTime = "";

    @SerializedName("start_location")
    private HTLocation startLocation;

    @SerializedName("tasks")
    private ArrayList<String> taskIDs;

    @SerializedName("driver_id")
    private String driverID;

    @SerializedName("vehicle_type")
    private HTDriverVehicleType vehicleType;

    @SerializedName("has_ordered_tasks")
    private boolean hasOrderedTasks;

    @SerializedName("is_auto_ended")
    private boolean isAutoEnded;

    public boolean hasOrderedTasks() {
        return hasOrderedTasks;
    }

    public String getTripID() {
        return tripID;
    }

    public void setTripID(String tripID) {
        this.tripID = tripID;
    }

    public void setOrderedTasks(boolean hasOrderedTasks) {
        this.hasOrderedTasks = hasOrderedTasks;
    }

    public boolean isAutoEnded() {
        return isAutoEnded;
    }

    public void setAutoEnded(boolean autoEnded) {
        isAutoEnded = autoEnded;
    }

    public HTDriverVehicleType getVehicleType() {
        return vehicleType;
    }

    public void setVehicleType(HTDriverVehicleType vehicleType) {
        this.vehicleType = vehicleType;
    }

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public HTLocation getStartLocation() {
        return startLocation;
    }

    public void setStartLocation(HTLocation startLocation) {
        this.startLocation = startLocation;
    }

    public ArrayList<String> getTaskIDs() {
        return taskIDs;
    }

    /**
     * Sets list of ids of tasks to be completed during a trip
     *
     * @param taskIDs
     */
    public void setTaskIDs(ArrayList<String> taskIDs) {
        this.taskIDs = taskIDs;
    }

    public String getDriverID() {
        return driverID;
    }

    /**
     * Sets ID of the Driver.
     *
     * @param driverID
     */
    public void setDriverID(String driverID) {
        this.driverID = driverID;
    }

    public HTTripParams(ArrayList<String> taskIDs, String driverID, HTDriverVehicleType vehicleType,
                        boolean hasOrderedTasks, boolean isAutoEnded) {
        this.taskIDs = taskIDs;
        this.driverID = driverID;
        this.vehicleType = vehicleType;
        this.hasOrderedTasks = hasOrderedTasks;
        this.isAutoEnded = isAutoEnded;
    }

    public HTTripParams(String tripID, ArrayList<String> taskIDs, String driverID, HTDriverVehicleType vehicleType,
                        boolean hasOrderedTasks, boolean isAutoEnded) {
        this(taskIDs, driverID, vehicleType, hasOrderedTasks, isAutoEnded);
        this.tripID = tripID;
    }

    @Override
    public String toString() {
        return "HTTripParams{" +
                "tripID=" + tripID +
                ", startLocation=" + startLocation +
                ", taskIDs=" + taskIDs +
                ", driverID=" + driverID +
                ", vehicleType=" + vehicleType +
                ", hasOrderedTasks=" + hasOrderedTasks +
                ", isAutoEnded=" + isAutoEnded +
                '}';
    }
}
