package io.hypertrack.lib.transmitter.model;

import java.util.ArrayList;

import io.hypertrack.lib.common.model.HTDriverVehicleType;

public class HTTripParamsBuilder {

    private String tripID;
    private ArrayList<String> taskIDs;
    private String driverID;
    private HTDriverVehicleType vehicleType;
    private boolean hasOrderedTasks = true;
    private boolean isAutoEnded = true;

    /**
     * Call this method to set the Trip ID for the trip to be performed by this driver.
     *
     * @param tripID Pass the id of the trip created as parameter.
     * @return
     */
    public HTTripParamsBuilder setTripID(String tripID) {
        this.tripID = tripID;
        return this;
    }

    /**
     *The orderId is the id of the order that needs to be tracked. This is obtained by creating the order from the API. Docs for this are available here:
     *https://4a266969b18b1589779c588e4d68948a92747dab.googledrive.com/host/0BxFwKXjNa3_Mfm1taG9vTUdkU3VfQ0tsZ0hnQmhKMDNrQUhGUEhkNUdfUmkxVUx1SnFzaUU/#create-a-new-order
     * @param taskIDs List of task ids
     * @return
     */
    public HTTripParamsBuilder setTaskIDs(ArrayList<String> taskIDs) {
        this.taskIDs = taskIDs;
        return this;
    }

    /**
     *The driverID is the id of the order which will be tracked. Docs for this are available here:
     *https://4a266969b18b1589779c588e4d68948a92747dab.googledrive.com/host/0BxFwKXjNa3_Mfm1taG9vTUdkU3VfQ0tsZ0hnQmhKMDNrQUhGUEhkNUdfUmkxVUx1SnFzaUU/#couriers
     * @param driverID
     * @return
     */
    public HTTripParamsBuilder setDriverID(String driverID) {
        this.driverID = driverID;
        return this;
    }

    public  HTTripParamsBuilder setVehicleType(HTDriverVehicleType vehicleType) {
        this.vehicleType = vehicleType;
        return this;
    }

    public HTTripParamsBuilder setOrderedTasks(boolean hasOrderedTasks) {
        this.hasOrderedTasks = hasOrderedTasks;
        return this;
    }

    public HTTripParamsBuilder setIsAutoEnded(boolean isAutoEnded) {
        this.isAutoEnded = isAutoEnded;
        return this;
    }

    /**
     *
     * @return
     */
    public HTTripParams createHTTripParams() {
        return new HTTripParams(tripID, taskIDs, driverID, vehicleType, hasOrderedTasks, isAutoEnded);
    }
}