package io.hypertrack.lib.transmitter.service;

import android.app.IntentService;
import android.content.Intent;
import android.support.v4.content.LocalBroadcastManager;

import com.google.android.gms.location.ActivityRecognitionResult;
import com.google.android.gms.location.DetectedActivity;

/**
 * Created by ulhas on 15/04/16.
 */
public class ActivityRecognitionIntentService extends IntentService {

    private static final String TAG = "ActivityRecognitionIntentService";

    public static final String ACTIVITY_CHANGED_INTENT_ACTION = "io.hypertrack.lib:ActivityRecognized";
    public static final String ACTIVITY_NAME_EXTRA_FIELD = "activity";
    public static final String ACTIVITY_CONFIDENCE_EXTRA_FIELD = "activityConfidence";

    public ActivityRecognitionIntentService() {
        super(TAG);
    }

    @Override
    protected void onHandleIntent (Intent intent) {

        if (ActivityRecognitionResult.hasResult(intent)) {

            ActivityRecognitionResult result = ActivityRecognitionResult.extractResult(intent);
            DetectedActivity mostProbableActivity = result.getMostProbableActivity();

            this.broadcastIntent(mostProbableActivity);
        }
    }

    private void broadcastIntent(DetectedActivity activity) {

        Intent intent = new Intent(ACTIVITY_CHANGED_INTENT_ACTION);
        intent.putExtra(ACTIVITY_NAME_EXTRA_FIELD, getActivityName(activity));
        intent.putExtra(ACTIVITY_CONFIDENCE_EXTRA_FIELD, activity.getConfidence());

        LocalBroadcastManager.getInstance(this).sendBroadcast(intent);
    }

    private static String getActivityName(DetectedActivity activity) {
        String activityName = "unknown";

        switch (activity.getType()) {
            case DetectedActivity.STILL:
                activityName = "stationary";
                break;

            case DetectedActivity.ON_BICYCLE:
                activityName = "cycling";
                break;

            case DetectedActivity.ON_FOOT:
                activityName = "walking";
                break;

            case DetectedActivity.RUNNING:
                activityName = "running";
                break;

            case DetectedActivity.IN_VEHICLE:
                activityName = "automotive";
                break;
        }

        return activityName;
    }
}
