package io.hypertrack.lib.transmitter.service;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;

import io.hypertrack.lib.common.logs.PostDeviceLogsManager;
import io.hypertrack.lib.common.network.HTHttpClient;
import io.hypertrack.lib.common.network.HTNetworkRequest;
import io.hypertrack.lib.transmitter.BuildConfig;

/**
 * Created by piyush on 20/10/16.
 */
public class BootReceiverService extends IntentService {
    private final static String VERSION_NAME = "TransmitterSDK/" + BuildConfig.VERSION_NAME;

    public BootReceiverService(){
        super(BootReceiverService.class.getSimpleName());
    }

    /**
     * Creates an IntentService.  Invoked by your subclass's constructor.
     *
     * @param name Used to name the worker thread, important only for debugging.
     */
    public BootReceiverService(String name) {
        super(name);
    }

    @Override
    protected void onHandleIntent(Intent intent) {

        Context mContext = getApplicationContext();

        // Check if LocationService is live and restart the service, if applicable
        HTTransmitterService transmitterService = HTTransmitterService.getInstance(mContext);
        if (transmitterService.isDriverLive()) {
            transmitterService.restartLocationServiceIfNotActive();
        }

        // Post DeviceLogs To Server
        if (HTHttpClient.isInternetConnected(mContext)) {
            if (PostDeviceLogsManager.getInstance(mContext).hasPendingDeviceLogs()) {
                PostDeviceLogsManager.getInstance(mContext).postDeviceLogs(VERSION_NAME,
                        HTNetworkRequest.HTNetworkClient.HT_NETWORK_CLIENT_HTTP);
            }
        }
    }
}
