package io.hypertrack.lib.transmitter.service;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;

import org.json.JSONObject;

import io.hypertrack.lib.common.model.HTConstants;
import io.hypertrack.lib.transmitter.model.TransmitterConstants;

/**
 * Created by piyush on 14/11/16.
 */
/** package */ class CollectDeviceInfo {
    public static void collect(Context context) {
        DeviceInfoList mDeviceInfoList = CollectDeviceInfo.initialize(context);

        if (mDeviceInfoList == null) {
            return;
        }

        JSONObject deviceInfoJSON = DeviceInfoUtility.getDeviceInfoJSON(context);

        if (!TextUtils.isEmpty(deviceInfoJSON.toString())) {
            mDeviceInfoList.addDeviceInfo(deviceInfoJSON);
        }
    }

    private static DeviceInfoList initialize(Context context) {
        if (TextUtils.isEmpty(CollectDeviceInfo.getDriverID(context))) {
            return null;
        }

        return new DeviceInfoList(CollectDeviceInfo.getDriverID(context),
                DeviceInfoDatabaseHelper.getInstance(context));
    }

    private static String getDriverID(Context context) {
        SharedPreferences sharedpreferences = context.getSharedPreferences(HTConstants.HT_SHARED_PREFERENCES_KEY, Context.MODE_PRIVATE);
        return sharedpreferences.getString(TransmitterConstants.HT_SHARED_PREFERENCE_DRIVER_ID_KEY, null);
    }
}
