package io.hypertrack.lib.transmitter.service;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;

import io.hypertrack.lib.common.util.HTLog;

/**
 * Created by piyush on 15/11/16.
 */
public class ConnectionLostReceiver extends BroadcastReceiver {
    private static final String TAG = ConnectionLostReceiver.class.getSimpleName();

    @Override
    public void onReceive(Context context, Intent intent) {
        HTLog.i(TAG, "Connection Lost broadcast received");

        // Start SDKConnectionChangedService to handle onConnectivityChanged
        Intent sdkConnectionOfflineIntent = new Intent(context, SDKConnectionChangedService.class);
        sdkConnectionOfflineIntent.putExtra(SDKConnectionChangedService.SDK_CONNECTION_ONLINE_KEY, false);
        context.startService(sdkConnectionOfflineIntent);
    }
}
