package io.hypertrack.lib.transmitter.service;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;

import io.hypertrack.lib.common.util.HTLog;

/**
 * Created by piyush on 15/11/16.
 */
public class ConnectivityChangeReceiver extends BroadcastReceiver {
    private static final String TAG = ConnectivityChangeReceiver.class.getSimpleName();

    @Override
    public void onReceive(Context context, Intent intent) {
        boolean isInternetEnabled = isInternetEnabled(context);

        if (isInternetEnabled) {
            HTLog.i(TAG, "ConnectivityChange receiver called. Connection enabled");

            // Start SDKConnectionChangedService to handle onConnectivityChanged
            Intent sdkConnectionOfflineIntent = new Intent(context, SDKConnectionChangedService.class);
            sdkConnectionOfflineIntent.putExtra(SDKConnectionChangedService.SDK_CONNECTION_ONLINE_KEY, true);
            context.startService(sdkConnectionOfflineIntent);
        }
    }

    private boolean isInternetEnabled(Context context) {
        try {
            ConnectivityManager cm = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
            if (cm != null) {
                NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
                return (activeNetwork != null && activeNetwork.isConnected());
            }
        } catch (Exception e) {
            e.printStackTrace();
            HTLog.e(TAG, "Exception occurred while isInternetEnabled: " + e);
        }

        return false;
    }
}
