package io.hypertrack.lib.transmitter.service;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

import org.json.JSONObject;

import java.util.List;

import io.hypertrack.lib.common.util.HTLog;

/**
 * Created by piyush on 09/08/16.
 */
/** package */ class DeviceInfoDatabaseHelper extends SQLiteOpenHelper implements DeviceInfoDataSource {

    private static final String TAG = DeviceInfoDatabaseHelper.class.getSimpleName();
    private static final String DATABASE_NAME = "io.hypertrack.lib.transmitter.device_info.db";
    private static final int DATABASE_VERSION = 1;

    private static DeviceInfoDatabaseHelper deviceInfoDatabaseHelper;
    private SQLiteDatabase database;

    private DeviceInfoDatabaseHelper(Context context) {
        super(context, DATABASE_NAME, null, DATABASE_VERSION);
        this.initializeDatabase();
    }

    private void initializeDatabase() {
        if (database == null)
            database = this.getWritableDatabase();
    }

    public static DeviceInfoDatabaseHelper getInstance(Context context) {
        if (deviceInfoDatabaseHelper == null) {
            deviceInfoDatabaseHelper = new DeviceInfoDatabaseHelper(context);
        }
        return deviceInfoDatabaseHelper;
    }

    @Override
    public void onCreate(SQLiteDatabase db) {
        DeviceInfoTable.onCreate(db);
        HTLog.i(TAG, "DeviceInfoDatabaseHelper onCreate called.");
    }

    @Override
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        DeviceInfoTable.onUpgrade(db, oldVersion, newVersion);
        HTLog.i(TAG, "DeviceInfoDatabaseHelper onUpgrade called.");
    }

    @Override
    public long getDeviceInfoCount() {
        // Initialize SQLiteDatabase if null
        initializeDatabase();

        long count = DeviceInfoTable.getCount(database);

        return count;
    }

    @Override
    public void addDeviceInfo(String driverId, JSONObject deviceInfo) {
        // Initialize SQLiteDatabase if null
        initializeDatabase();

        DeviceInfoTable.addDeviceInfo(database, driverId, deviceInfo);
    }

    @Override
    public void addDeviceInfo(String driverID, List<JSONObject> deviceInfoList) {
        // Initialize SQLiteDatabase if null
        initializeDatabase();

        DeviceInfoTable.addDeviceInfo(database, driverID, deviceInfoList);
    }

    @Override
    public void deleteDeviceInfo(List<DeviceInfo> deviceInfoList) {
        // Initialize SQLiteDatabase if null
        initializeDatabase();

        DeviceInfoTable.deleteDeviceInfo(database, deviceInfoList);
    }

    @Override
    public void deleteAllDeviceInfo() {
        // Initialize SQLiteDatabase if null
        initializeDatabase();

        DeviceInfoTable.deleteAllDeviceInfo(database);
    }

    @Override
    public List<DeviceInfo> getDeviceInfoForDriverID(String driverID) {
        try {
            // Initialize SQLiteDatabase if null
            initializeDatabase();

            List<DeviceInfo> deviceInfoList;
            deviceInfoList = DeviceInfoTable.getDeviceInfoWithDriverID(database, driverID);

            return deviceInfoList;
        } catch (OutOfMemoryError e) {
            e.printStackTrace();
        } catch (Exception e) {
            HTLog.e(TAG, "Exception occurred while getDeviceInfoForDriverID: " + e);
        }

        return null;
    }

    @Override
    public void deleteAllDeviceInfoOtherThanDriverID(String driverID) {
        // Initialize SQLiteDatabase if null
        initializeDatabase();

        DeviceInfoTable.deleteDeviceInfoOtherThanDriverID(database, driverID);
    }
}