package io.hypertrack.lib.transmitter.service;

import android.text.TextUtils;

import org.json.JSONObject;

import java.util.List;

/**
 * Created by piyush on 09/08/16.
 */
/** package */ class DeviceInfoList {

    private String driverID;
    private DeviceInfoDataSource mDeviceInfoDataSource;

    public DeviceInfoList(String driverID, DeviceInfoDataSource mDeviceInfoDataSource) {
        this.driverID = driverID;
        this.mDeviceInfoDataSource = mDeviceInfoDataSource;
    }

    public void addDeviceInfo(JSONObject deviceInfo) {
        if (TextUtils.isEmpty(deviceInfo.toString())) {
            return;
        }

        this.mDeviceInfoDataSource.addDeviceInfo(driverID, deviceInfo);
    }

    public void addDeviceInfo(List<JSONObject> deviceInfoList) {
        if (deviceInfoList == null || deviceInfoList.isEmpty()) {
            return;
        }

        this.mDeviceInfoDataSource.addDeviceInfo(driverID, deviceInfoList);
    }

    public void clearSavedDeviceInfo() {
        this.mDeviceInfoDataSource.deleteAllDeviceInfo();
    }

    private List<DeviceInfo> getSavedDeviceInfoForDriverID(String driverID) {
        return this.mDeviceInfoDataSource.getDeviceInfoForDriverID(driverID);
    }

    public List<DeviceInfo> getDeviceInfoListWithDriverID(String driverID) {
        return this.getSavedDeviceInfoForDriverID(driverID);
    }

    public void clearDeviceInfo(List<DeviceInfo> pushedDeviceInfo) {
        if (pushedDeviceInfo == null || pushedDeviceInfo.isEmpty())
            return;

        this.mDeviceInfoDataSource.deleteDeviceInfo(pushedDeviceInfo);
    }

    public long count() {
        return this.mDeviceInfoDataSource.getDeviceInfoCount();
    }

    public void clearDeviceInfoOtherThanDriverID(String driverID) {
        if (TextUtils.isEmpty(driverID)) {
            return;
        }

        this.mDeviceInfoDataSource.deleteAllDeviceInfoOtherThanDriverID(driverID);
    }
}
