package io.hypertrack.lib.transmitter.service;

import java.util.ArrayList;
import java.util.List;

import io.hypertrack.lib.common.util.ListUtility;

/**
 * Created by piyush on 09/08/16.
 */
/** package */ class DeviceInfoRequestList {
    private static final int DEVICE_INFO_BATCH_SIZE = 50;

    private List<DeviceInfoRequest> requests;

    public List<DeviceInfoRequest> getRequests() {
        return requests;
    }

    public DeviceInfoRequestList(List<DeviceInfo> deviceInfo) {
        if (deviceInfo == null || deviceInfo.isEmpty()) {
            return;
        }

        List<List<DeviceInfo>> deviceInfoBatches = ListUtility.partition(deviceInfo, DEVICE_INFO_BATCH_SIZE);

        List<DeviceInfoRequest> requests = new ArrayList<>();
        for (List<DeviceInfo> deviceInfoBatch : deviceInfoBatches) {
            requests.add(new DeviceInfoRequest(deviceInfoBatch));
        }

        this.requests = requests;
    }

    public boolean haveAllLogsBeenPosted() {
        boolean hasCompleted = true;

        for (DeviceInfoRequest request : requests) {
            if (request.isCompleted() == null) {
                hasCompleted = false;
                break;
            }
        }

        return hasCompleted;
    }

    public boolean haveAllLogsBeenPostedSuccessfully() {
        boolean hasCompleted = true;

        for (DeviceInfoRequest request : requests) {
            if (request.isCompleted() == null || !request.isCompleted()) {
                hasCompleted = false;
                break;
            }
        }

        return hasCompleted;
    }
}
