package io.hypertrack.lib.transmitter.service;

import android.content.Context;
import android.content.SharedPreferences;

import org.json.JSONObject;

import io.hypertrack.lib.common.model.BatteryState;
import io.hypertrack.lib.common.model.HTConstants;
import io.hypertrack.lib.common.util.DateTimeUtility;
import io.hypertrack.lib.common.util.HTLog;
import io.hypertrack.lib.transmitter.model.TransmitterConstants;

/**
 * Created by piyush on 05/08/16.
 */
/** package */ class DeviceInfoUtility {

    private static final String TAG = "DeviceInfoUtility";

    private static final String KEY_BATTERY_INFO_JSON = "battery";
    private static final String KEY_RADIO_INFO_JSON = "radio";
    private static final String KEY_LOCATION_INFO_JSON = "location";
    private static final String KEY_DEVICE_MODEL_INFO_JSON = "device";
    private static final String KEY_DRIVER_ID = "driver_id";
    private static final String KEY_RECORDED_AT = "recorded_at";

    public static JSONObject getDeviceInfoJSON(Context context) {
        JSONObject jsonObject = new JSONObject();

        try {
            jsonObject.put(KEY_DRIVER_ID, getDriverID(context));
            jsonObject.put(KEY_RECORDED_AT, DateTimeUtility.getCurrentTime());

            JSONObject batteryJSON = getDeviceBatteryJSON(context);
            JSONObject radioJSON = getDeviceRadioJSON(context);
            JSONObject locationJSON = getDeviceLocationJSON(context);
            JSONObject deviceModelJSON = getDeviceModelJSON(context);

            if (batteryJSON != null)
                jsonObject.put(KEY_BATTERY_INFO_JSON, batteryJSON);

            if (radioJSON != null)
                jsonObject.put(KEY_RADIO_INFO_JSON, radioJSON);

            if (locationJSON != null)
                jsonObject.put(KEY_LOCATION_INFO_JSON, locationJSON);

            if (deviceModelJSON != null)
                jsonObject.put(KEY_DEVICE_MODEL_INFO_JSON, deviceModelJSON);

        } catch (Exception e) {
            e.printStackTrace();
            HTLog.w(TAG, "Exception occurred while getDeviceBatteryJSON: " + e.getMessage());
        }

        return jsonObject;
    }

    private static JSONObject getDeviceBatteryJSON(Context context) {
        BatteryState batteryState = new BatteryState(context);
        return batteryState.getBatteryInfo();
    }

    private static JSONObject getDeviceRadioJSON(Context context) {
        RadioState radioState = new RadioState(context);
        return radioState.getRadioInfo();
    }

    private static JSONObject getDeviceLocationJSON(Context context) {
        LocationState locationState = new LocationState(context);
        return locationState.getLocationInfo();
    }

    private static JSONObject getDeviceModelJSON(Context context) {
        DeviceModelState deviceModelState = new DeviceModelState(context);
        return deviceModelState.getDeviceModelInfo();
    }

    private static String getDriverID(Context context) {
        SharedPreferences sharedpreferences = context.getSharedPreferences(HTConstants.HT_SHARED_PREFERENCES_KEY, Context.MODE_PRIVATE);
        return sharedpreferences.getString(TransmitterConstants.HT_SHARED_PREFERENCE_DRIVER_ID_KEY, "");
    }

    public static void clearSavedDeviceInfoParams(Context context) {
        BatteryState.clearSavedBatteryStateData(context);
        RadioState.clearSavedRadioStateData(context);
        LocationState.clearSavedLocationStateData(context);
        DeviceModelState.clearSavedDeviceModelStateData(context);
    }
}
