package io.hypertrack.lib.transmitter.service;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.provider.Settings;
import android.text.TextUtils;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.TimeZone;

import io.hypertrack.lib.common.model.HTConstants;
import io.hypertrack.lib.common.util.HTLog;
import io.hypertrack.lib.transmitter.BuildConfig;

/**
 * Created by piyush on 06/08/16.
 */
/** package */ class DeviceModelState {
    private static final String TAG = "DeviceModelState";

    private static final String HT_SHARED_PREFERENCE_DEVICE_ID = "io.hypertrack.lib:SharedPreferenceDeviceID";
    private static final String HT_SHARED_PREFERENCE_OS = "io.hypertrack.lib:SharedPreferenceOS";
    private static final String HT_SHARED_PREFERENCE_OS_VERSION = "io.hypertrack.lib:SharedPreferenceOSVersion";
    private static final String HT_SHARED_PREFERENCE_CUSTOM_OS_VERSION = "io.hypertrack.lib:SharedPreferenceCustomOSVersion";
    private static final String HT_SHARED_PREFERENCE_SDK_VERSION = "io.hypertrack.lib:SharedPreferenceSDKVersion";
    private static final String HT_SHARED_PREFERENCE_DEVICE = "io.hypertrack.lib:SharedPreferenceDevice";
    private static final String HT_SHARED_PREFERENCE_MODEL = "io.hypertrack.lib:SharedPreferenceModel";
    private static final String HT_SHARED_PREFERENCE_PRODUCT = "io.hypertrack.lib:SharedPreferenceProduct";
    private static final String HT_SHARED_PREFERENCE_BRAND = "io.hypertrack.lib:SharedPreferenceBrand";
    private static final String HT_SHARED_PREFERENCE_MANUFACTURER = "io.hypertrack.lib:SharedPreferenceManufacturer";
    private static final String HT_SHARED_PREFERENCE_TIME_ZONE = "io.hypertrack.lib:SharedPreferenceTimeZone";

    private static final String KEY_DEVICE_ID = "device_id";
    private static final String KEY_OS = "os";
    private static final String KEY_OS_VERSION = "os_version";
    private static final String KEY_CUSTOM_OS_VERSION = "custom_os_version";
    private static final String KEY_SDK_VERSION = "sdk_version";
    private static final String KEY_DEVICE = "device";
    private static final String KEY_MODEL = "model";
    private static final String KEY_PRODUCT = "product";
    private static final String KEY_BRAND = "brand";
    private static final String KEY_MANUFACTURER = "manufacturer";
    private static final String KEY_TIME_ZONE = "time_zone";

    private Context mContext;

    public DeviceModelState(Context mContext) {
        this.mContext = mContext;
    }

    public JSONObject getDeviceModelInfo() {
        JSONObject jsonObject = new JSONObject();

        try {
            // Fetch Current DeviceModelState Params
            String deviceID = getDeviceId(mContext);
            String os = "Android";
            String osVersion = Build.VERSION.RELEASE;
            String customOSVersion = System.getProperty("os.version");
            String sdkVersion = BuildConfig.VERSION_NAME;
            String device = Build.DEVICE;
            String model = Build.MODEL;
            String product = Build.PRODUCT;
            String brand = Build.BRAND;
            String manufacturer = Build.MANUFACTURER;
            String timeZone = TimeZone.getDefault().getID();

            // Fetch Cached DeviceModelState Params
            String savedDeviceID = getSavedDeviceID();
            String savedOS = getSavedOS();
            String savedOSVersion = getSavedOSVersion();
            String savedCustomOSVersion = getSavedCustomOSVersion();
            String savedSdkVersion = getSavedSDKVersion();
            String savedDevice = getSavedDevice();
            String savedModel = getSavedModel();
            String savedProduct = getSavedProduct();
            String savedBrand = getSavedBrand();
            String savedManufacturer = getSavedManufacturer();
            String savedTimeZone = getSavedTimeZone();

            // Add only updated data to deviceModelState JSON
            if (TextUtils.isEmpty(savedDeviceID) || !savedDeviceID.equalsIgnoreCase(deviceID)) {
                setDeviceID(deviceID);
                jsonObject.put(KEY_DEVICE_ID, deviceID);
            }

            if (TextUtils.isEmpty(savedOS) || !savedOS.equalsIgnoreCase(os)) {
                setOS(os);
                jsonObject.put(KEY_OS, os);
            }

            if (TextUtils.isEmpty(savedOSVersion) || !savedOSVersion.equalsIgnoreCase(osVersion)) {
                setOSVersion(osVersion);
                jsonObject.put(KEY_OS_VERSION, osVersion);
            }

            if (TextUtils.isEmpty(savedCustomOSVersion) || !savedCustomOSVersion.equalsIgnoreCase(customOSVersion)) {
                setCustomOSVersion(customOSVersion);
                jsonObject.put(KEY_CUSTOM_OS_VERSION, customOSVersion);
            }

            if (TextUtils.isEmpty(savedSdkVersion) || !savedSdkVersion.equalsIgnoreCase(sdkVersion)) {
                setSDKVersion(sdkVersion);
                jsonObject.put(KEY_SDK_VERSION, sdkVersion);
            }

            if (TextUtils.isEmpty(savedDevice) || !savedDevice.equalsIgnoreCase(device)) {
                setDevice(device);
                jsonObject.put(KEY_DEVICE, device);
            }

            if (TextUtils.isEmpty(savedModel) || !savedModel.equalsIgnoreCase(model)) {
                setModel(model);
                jsonObject.put(KEY_MODEL, model);
            }

            if (TextUtils.isEmpty(savedProduct) || !savedProduct.equalsIgnoreCase(product)) {
                setProduct(product);
                jsonObject.put(KEY_PRODUCT, product);
            }

            if (TextUtils.isEmpty(savedBrand) || !savedBrand.equalsIgnoreCase(brand)) {
                setBrand(brand);
                jsonObject.put(KEY_BRAND, brand);
            }

            if (TextUtils.isEmpty(savedManufacturer) || !savedManufacturer.equalsIgnoreCase(manufacturer)) {
                setManufacturer(manufacturer);
                jsonObject.put(KEY_MANUFACTURER, manufacturer);
            }

            if (TextUtils.isEmpty(savedTimeZone) || !savedTimeZone.equalsIgnoreCase(timeZone)) {
                setTimeZone(timeZone);
                jsonObject.put(KEY_TIME_ZONE, timeZone);
            }

        } catch (JSONException e) {
            e.printStackTrace();
            HTLog.w(TAG, "Exception occurred while getDeviceModelInfo: " + e.getMessage());
        }

        return jsonObject.length() > 0 ? jsonObject : null;
    }

    public static String getDeviceId(Context context) {
        String device_uuid = Settings.Secure.getString(context.getContentResolver(), Settings.Secure.ANDROID_ID);
        return device_uuid != null ? device_uuid : "";
    }

    // Methods for Caching & Fetching DeviceID
    private String getSavedDeviceID() {
        SharedPreferences sharedpreferences = mContext.getSharedPreferences(HTConstants.HT_DEVICE_INFO_SHARED_PREFERENCES_KEY, Context.MODE_PRIVATE);
        return sharedpreferences.getString(HT_SHARED_PREFERENCE_DEVICE_ID, null);
    }

    private void setDeviceID(String deviceID) {
        SharedPreferences sharedpreferences = mContext.getSharedPreferences(HTConstants.HT_DEVICE_INFO_SHARED_PREFERENCES_KEY, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sharedpreferences.edit();
        editor.putString(HT_SHARED_PREFERENCE_DEVICE_ID, deviceID);
        editor.apply();
    }

    // Methods for Caching & Fetching OS
    private String getSavedOS() {
        SharedPreferences sharedpreferences = mContext.getSharedPreferences(HTConstants.HT_DEVICE_INFO_SHARED_PREFERENCES_KEY, Context.MODE_PRIVATE);
        return sharedpreferences.getString(HT_SHARED_PREFERENCE_OS, null);
    }

    private void setOS(String os) {
        SharedPreferences sharedpreferences = mContext.getSharedPreferences(HTConstants.HT_DEVICE_INFO_SHARED_PREFERENCES_KEY, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sharedpreferences.edit();
        editor.putString(HT_SHARED_PREFERENCE_OS, os);
        editor.apply();
    }

    // Methods for Caching & Fetching OSVersion
    private String getSavedOSVersion() {
        SharedPreferences sharedpreferences = mContext.getSharedPreferences(HTConstants.HT_DEVICE_INFO_SHARED_PREFERENCES_KEY, Context.MODE_PRIVATE);
        return sharedpreferences.getString(HT_SHARED_PREFERENCE_OS_VERSION, null);
    }

    private void setOSVersion(String osVersion) {
        SharedPreferences sharedpreferences = mContext.getSharedPreferences(HTConstants.HT_DEVICE_INFO_SHARED_PREFERENCES_KEY, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sharedpreferences.edit();
        editor.putString(HT_SHARED_PREFERENCE_OS_VERSION, osVersion);
        editor.apply();
    }

    // Methods for Caching & Fetching CustomOSVersion
    private String getSavedCustomOSVersion() {
        SharedPreferences sharedpreferences = mContext.getSharedPreferences(HTConstants.HT_DEVICE_INFO_SHARED_PREFERENCES_KEY, Context.MODE_PRIVATE);
        return sharedpreferences.getString(HT_SHARED_PREFERENCE_CUSTOM_OS_VERSION, null);
    }

    private void setCustomOSVersion(String customOSVersion) {
        SharedPreferences sharedpreferences = mContext.getSharedPreferences(HTConstants.HT_DEVICE_INFO_SHARED_PREFERENCES_KEY, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sharedpreferences.edit();
        editor.putString(HT_SHARED_PREFERENCE_CUSTOM_OS_VERSION, customOSVersion);
        editor.apply();
    }

    // Methods for Caching & Fetching SDKVersion
    private String getSavedSDKVersion() {
        SharedPreferences sharedpreferences = mContext.getSharedPreferences(HTConstants.HT_DEVICE_INFO_SHARED_PREFERENCES_KEY, Context.MODE_PRIVATE);
        return sharedpreferences.getString(HT_SHARED_PREFERENCE_SDK_VERSION, null);
    }

    private void setSDKVersion(String sdkVersion) {
        SharedPreferences sharedpreferences = mContext.getSharedPreferences(HTConstants.HT_DEVICE_INFO_SHARED_PREFERENCES_KEY, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sharedpreferences.edit();
        editor.putString(HT_SHARED_PREFERENCE_SDK_VERSION, sdkVersion);
        editor.apply();
    }

    // Methods for Caching & Fetching Device name
    private String getSavedDevice() {
        SharedPreferences sharedpreferences = mContext.getSharedPreferences(HTConstants.HT_DEVICE_INFO_SHARED_PREFERENCES_KEY, Context.MODE_PRIVATE);
        return sharedpreferences.getString(HT_SHARED_PREFERENCE_DEVICE, null);
    }

    private void setDevice(String  device) {
        SharedPreferences sharedpreferences = mContext.getSharedPreferences(HTConstants.HT_DEVICE_INFO_SHARED_PREFERENCES_KEY, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sharedpreferences.edit();
        editor.putString(HT_SHARED_PREFERENCE_DEVICE, device);
        editor.apply();
    }

    // Methods for Caching & Fetching Model name
    private String getSavedModel() {
        SharedPreferences sharedpreferences = mContext.getSharedPreferences(HTConstants.HT_DEVICE_INFO_SHARED_PREFERENCES_KEY, Context.MODE_PRIVATE);
        return sharedpreferences.getString(HT_SHARED_PREFERENCE_MODEL, null);
    }

    private void setModel(String  model) {
        SharedPreferences sharedpreferences = mContext.getSharedPreferences(HTConstants.HT_DEVICE_INFO_SHARED_PREFERENCES_KEY, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sharedpreferences.edit();
        editor.putString(HT_SHARED_PREFERENCE_MODEL, model);
        editor.apply();
    }

    // Methods for Caching & Fetching Product name
    private String getSavedProduct() {
        SharedPreferences sharedpreferences = mContext.getSharedPreferences(HTConstants.HT_DEVICE_INFO_SHARED_PREFERENCES_KEY, Context.MODE_PRIVATE);
        return sharedpreferences.getString(HT_SHARED_PREFERENCE_PRODUCT, null);
    }

    private void setProduct(String product) {
        SharedPreferences sharedpreferences = mContext.getSharedPreferences(HTConstants.HT_DEVICE_INFO_SHARED_PREFERENCES_KEY, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sharedpreferences.edit();
        editor.putString(HT_SHARED_PREFERENCE_PRODUCT, product);
        editor.apply();
    }

    // Methods for Caching & Fetching Brand name
    private String getSavedBrand() {
        SharedPreferences sharedpreferences = mContext.getSharedPreferences(HTConstants.HT_DEVICE_INFO_SHARED_PREFERENCES_KEY, Context.MODE_PRIVATE);
        return sharedpreferences.getString(HT_SHARED_PREFERENCE_BRAND, null);
    }

    private void setBrand(String brand) {
        SharedPreferences sharedpreferences = mContext.getSharedPreferences(HTConstants.HT_DEVICE_INFO_SHARED_PREFERENCES_KEY, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sharedpreferences.edit();
        editor.putString(HT_SHARED_PREFERENCE_BRAND, brand);
        editor.apply();
    }

    // Methods for Caching & Fetching Manufacturer name
    private String getSavedManufacturer() {
        SharedPreferences sharedpreferences = mContext.getSharedPreferences(HTConstants.HT_DEVICE_INFO_SHARED_PREFERENCES_KEY, Context.MODE_PRIVATE);
        return sharedpreferences.getString(HT_SHARED_PREFERENCE_MANUFACTURER, null);
    }

    private void setManufacturer(String manufacturer) {
        SharedPreferences sharedpreferences = mContext.getSharedPreferences(HTConstants.HT_DEVICE_INFO_SHARED_PREFERENCES_KEY, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sharedpreferences.edit();
        editor.putString(HT_SHARED_PREFERENCE_MANUFACTURER, manufacturer);
        editor.apply();
    }

    // Methods for Caching & Fetching TimeZone name
    private String getSavedTimeZone() {
        SharedPreferences sharedpreferences = mContext.getSharedPreferences(HTConstants.HT_DEVICE_INFO_SHARED_PREFERENCES_KEY, Context.MODE_PRIVATE);
        return sharedpreferences.getString(HT_SHARED_PREFERENCE_TIME_ZONE, null);
    }

    private void setTimeZone(String timeZone) {
        SharedPreferences sharedpreferences = mContext.getSharedPreferences(HTConstants.HT_DEVICE_INFO_SHARED_PREFERENCES_KEY, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sharedpreferences.edit();
        editor.putString(HT_SHARED_PREFERENCE_TIME_ZONE, timeZone);
        editor.apply();
    }

    // Methods to clear cached LocationState Data
    public static void clearSavedDeviceModelStateData(Context context) {
        DeviceModelState.clearSavedDeviceID(context);
        DeviceModelState.clearSavedOS(context);
        DeviceModelState.clearSavedOSVersion(context);
        DeviceModelState.clearSavedCustomOSVersion(context);
        DeviceModelState.clearSavedSDKVersion(context);
        DeviceModelState.clearSavedDevice(context);
        DeviceModelState.clearSavedModel(context);
        DeviceModelState.clearSavedProduct(context);
        DeviceModelState.clearSavedBrand(context);
        DeviceModelState.clearSavedManufacturer(context);
        DeviceModelState.clearSavedTimeZone(context);
    }

    private static void clearSavedDeviceID(Context context) {
        SharedPreferences sharedpreferences = context.getSharedPreferences(HTConstants.HT_DEVICE_INFO_SHARED_PREFERENCES_KEY, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sharedpreferences.edit();
        editor.remove(HT_SHARED_PREFERENCE_DEVICE_ID);
        editor.apply();
    }

    private static void clearSavedOS(Context context) {
        SharedPreferences sharedpreferences = context.getSharedPreferences(HTConstants.HT_DEVICE_INFO_SHARED_PREFERENCES_KEY, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sharedpreferences.edit();
        editor.remove(HT_SHARED_PREFERENCE_OS);
        editor.apply();
    }

    private static void clearSavedOSVersion(Context context) {
        SharedPreferences sharedpreferences = context.getSharedPreferences(HTConstants.HT_DEVICE_INFO_SHARED_PREFERENCES_KEY, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sharedpreferences.edit();
        editor.remove(HT_SHARED_PREFERENCE_OS_VERSION);
        editor.apply();
    }

    private static void clearSavedCustomOSVersion(Context context) {
        SharedPreferences sharedpreferences = context.getSharedPreferences(HTConstants.HT_DEVICE_INFO_SHARED_PREFERENCES_KEY, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sharedpreferences.edit();
        editor.remove(HT_SHARED_PREFERENCE_CUSTOM_OS_VERSION);
        editor.apply();
    }

    private static void clearSavedSDKVersion(Context context) {
        SharedPreferences sharedpreferences = context.getSharedPreferences(HTConstants.HT_DEVICE_INFO_SHARED_PREFERENCES_KEY, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sharedpreferences.edit();
        editor.remove(HT_SHARED_PREFERENCE_SDK_VERSION);
        editor.apply();
    }

    private static void clearSavedDevice(Context context) {
        SharedPreferences sharedpreferences = context.getSharedPreferences(HTConstants.HT_DEVICE_INFO_SHARED_PREFERENCES_KEY, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sharedpreferences.edit();
        editor.remove(HT_SHARED_PREFERENCE_DEVICE);
        editor.apply();
    }

    private static void clearSavedModel(Context context) {
        SharedPreferences sharedpreferences = context.getSharedPreferences(HTConstants.HT_DEVICE_INFO_SHARED_PREFERENCES_KEY, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sharedpreferences.edit();
        editor.remove(HT_SHARED_PREFERENCE_MODEL);
        editor.apply();
    }

    private static void clearSavedProduct(Context context) {
        SharedPreferences sharedpreferences = context.getSharedPreferences(HTConstants.HT_DEVICE_INFO_SHARED_PREFERENCES_KEY, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sharedpreferences.edit();
        editor.remove(HT_SHARED_PREFERENCE_PRODUCT);
        editor.apply();
    }

    private static void clearSavedBrand(Context context) {
        SharedPreferences sharedpreferences = context.getSharedPreferences(HTConstants.HT_DEVICE_INFO_SHARED_PREFERENCES_KEY, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sharedpreferences.edit();
        editor.remove(HT_SHARED_PREFERENCE_BRAND);
        editor.apply();
    }

    private static void clearSavedManufacturer(Context context) {
        SharedPreferences sharedpreferences = context.getSharedPreferences(HTConstants.HT_DEVICE_INFO_SHARED_PREFERENCES_KEY, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sharedpreferences.edit();
        editor.remove(HT_SHARED_PREFERENCE_MANUFACTURER);
        editor.apply();
    }

    private static void clearSavedTimeZone(Context context) {
        SharedPreferences sharedpreferences = context.getSharedPreferences(HTConstants.HT_DEVICE_INFO_SHARED_PREFERENCES_KEY, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sharedpreferences.edit();
        editor.remove(HT_SHARED_PREFERENCE_TIME_ZONE);
        editor.apply();
    }
}
