package io.hypertrack.lib.transmitter.service;

import android.location.Location;

import com.google.gson.annotations.SerializedName;

import java.util.Date;

import io.hypertrack.lib.common.model.HTLocation;

/** package */ class EndTripRequest {

    @SerializedName("end_location")
    private HTLocation endLocation;

    @SerializedName("ended_at")
    private Date endTime;

    @Override
    public String toString() {
        return "EndTripRequest{" +
                "endLocation=" + (endLocation != null ? endLocation : "") +
                ", endTime=" + endTime +
                '}';
    }

    public HTLocation getEndLocation() {
        return endLocation;
    }

    public void setEndLocation(HTLocation endLocation) {
        this.endLocation = endLocation;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public EndTripRequest(Location location, Date endTime) {
        if (location != null) {
            this.endLocation = new HTLocation(location);
        }

        this.endTime = endTime;
    }
}
