package io.hypertrack.lib.transmitter.service;

import android.location.Location;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;

import java.util.List;

import io.hypertrack.lib.common.model.HTGPSLocation;
import io.hypertrack.lib.common.util.DateTimeUtility;

/** package */ class GPSLocation extends HTGPSLocation{

    @Expose(serialize = false, deserialize = false)
    private int id;

    @SerializedName("trip_id")
    private String tripID;

    @SerializedName("driver_id")
    private String driverID;

    @SerializedName("activities")
    private List<String> activities;

    @SerializedName("activity_confidence")
    private Integer activityConfidence;

    @SerializedName("provider")
    private String provider;

    @SerializedName("recorded_at")
    private String recordedAt;

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getTripID() {
        return tripID;
    }

    public void setTripID(String tripID) {
        this.tripID = tripID;
    }

    public String getDriverID() {
        return driverID;
    }

    public void setDriverID(String driverID) {
        this.driverID = driverID;
    }

    public List<String> getActivities() {
        return activities;
    }

    public void setActivities(List<String> activities) {
        this.activities = activities;
    }

    public Integer getActivityConfidence() {
        return activityConfidence;
    }

    public void setActivityConfidence(Integer activityConfidence) {
        this.activityConfidence = activityConfidence;
    }

    public String getProvider() {
        return provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getRecordedAt() {
        return recordedAt;
    }

    public void setRecordedAt(String recordedAt) {
        this.recordedAt = recordedAt;
    }

    @Override
    public String toString() {
        return "GPSLocation{" +
                "location=" + getLocation() +
                ", locationAccuracy=" + getLocationAccuracy() +
                ", speed=" + getSpeed() +
                ", bearing=" + getBearing() +
                ", altitude=" + getAltitude() +
                ", recordedAt='" + getRecordedAt() + '\'' +
                ", tripID='" + tripID + '\'' +
                ", activities=" + activities +
                ", activityConfidence=" + activityConfidence +
                '}';
    }

    private GPSLocation () {
    }

    public GPSLocation(Location location) {
        this(location, null);
    }

    public GPSLocation(Location location, String provider) {
        super(location);

        this.recordedAt = DateTimeUtility.getCurrentTime();
        this.provider = provider;
    }

    public void setActivityDetails(List<String> activities, Integer activityConfidence) {
        this.setActivities(activities);
        this.setActivityConfidence(activityConfidence);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }

        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }

        if (getLocation() == null) {
            return false;
        }

        GPSLocation gpsLocation = (GPSLocation) o;

        if (gpsLocation.getLocation() == null) {
            return false;
        }

        return this.getLocation().equals(gpsLocation.getLocation());
    }
}