package io.hypertrack.lib.transmitter.service;

import android.text.TextUtils;

import java.util.List;

import io.hypertrack.lib.common.util.HTLog;

/**
 * Created by ulhas on 07/05/16.
 */
/** package */ class GPSLocationList {
    private static final String TAG = GPSLocationList.class.getSimpleName();
    private LocationDataSource mLocationDataSource;

    public GPSLocationList(LocationDataSource locationDataSource) {
        this.mLocationDataSource = locationDataSource;
    }

    public void addLocation(GPSLocation location) {
        if (location == null) {
            HTLog.e(TAG, "GPSLocation is NULL in addLocation");
            return;
        }

        this.mLocationDataSource.addLocation(location);
    }

    public void addLocations(List<GPSLocation> locations) {
        if (locations == null || locations.isEmpty()) {
            return;
        }

        this.mLocationDataSource.addLocations(locations);
    }

    public void clearSavedLocations() {
        this.mLocationDataSource.deleteAllLocations();
    }

    private List<GPSLocation> getSavedLocationsForTripID(String tripID) {
        return this.mLocationDataSource.getLocationsForTripID(tripID);
    }

    private List<GPSLocation> getSavedLocationsForDriverID(String driverID) {
        return this.mLocationDataSource.getLocationsForDriverID(driverID);
    }

    public List<GPSLocation> getLocationsListWithTripID(String tripID) {
        List<GPSLocation> gpsLocations = this.getSavedLocationsForTripID(tripID);
        return gpsLocations;
    }

    public List<GPSLocation> getLocationsListWithDriverID(String driverID) {
        List<GPSLocation> gpsLocations = this.getSavedLocationsForDriverID(driverID);
        return gpsLocations;
    }

    public void clearLocations(List<GPSLocation> pushedLocations) {
        if (pushedLocations == null || pushedLocations.isEmpty())
            return;

        this.mLocationDataSource.deleteLocations(pushedLocations);
    }

    public long count() {
        return this.mLocationDataSource.getLocationCount();
    }

    public void clearLocationsOtherThanTripID(String tripID) {
        if (TextUtils.isEmpty(tripID)) {
            return;
        }

        this.mLocationDataSource.deleteAllLocationsOtherThanTripID(tripID);
    }

    public void clearLocationsOtherThanDriverID(String driverID) {
        if (TextUtils.isEmpty(driverID)) {
            return;
        }

        this.mLocationDataSource.deleteAllLocationsOtherThanDriverID(driverID);
    }
}