package io.hypertrack.lib.transmitter.service;

/**
 * Created by ulhas on 17/05/16.
 */

import java.util.ArrayList;
import java.util.List;

import io.hypertrack.lib.common.util.ListUtility;

/** package */ class GPSLogRequestList {

    private static final int GPS_LOG_BATCH_SIZE = 50;

    private List<GPSLogRequest> requests;

    public List<GPSLogRequest> getRequests() {
        return requests;
    }

    public GPSLogRequestList(List<GPSLocation> locations) {
        if (locations.isEmpty()) {
            return;
        }

        List<List<GPSLocation>> locationBatches = ListUtility.partition(locations, GPS_LOG_BATCH_SIZE);
        List<GPSLogRequest> requests = new ArrayList<>();
        for (List<GPSLocation> locationBatch : locationBatches) {
            requests.add(new GPSLogRequest(locationBatch));
        }

        this.requests = requests;
    }

    public boolean haveAllLogsBeenPosted() {
        boolean hasCompleted = true;

        for (GPSLogRequest request : requests) {
            if (request.isCompleted() == null) {
                hasCompleted = false;
                break;
            }
        }

        return hasCompleted;
    }

    public boolean haveAllLogsBeenPostedSuccessfully() {
        boolean hasCompleted = true;

        for (GPSLogRequest request : requests) {
            if (request.isCompleted() == null || !request.isCompleted()) {
                hasCompleted = false;
                break;
            }
        }

        return hasCompleted;
    }
}
