package io.hypertrack.lib.transmitter.service;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;

import io.hypertrack.lib.common.util.HTLog;
import io.hypertrack.lib.common.util.Utils;

/**
 * Created by piyush on 10/10/16.
 */
public class HTPowerSaverModeChangedReceiver extends BroadcastReceiver {
    private static final String TAG = HTPowerSaverModeChangedReceiver.class.getSimpleName();

    @Override
    public void onReceive(Context context, Intent intent) {

        HTLog.i(TAG, "HTPowerSaverModeChangedReceiver: onReceive() called");

        if (Utils.checkIfPowerSaverModeEnabled(context)) {
            HTLog.i(TAG, "PowerSaver Mode ENABLED.");

            // Reset HTJobScheduler on PowerSaverMode enabled
            HTTransmitterService.getInstance(context).getJobScheduler().onPowerSaverModeChanged(true);

        } else {
            HTLog.i(TAG, "PowerSaver Mode DISABLED.");

            // Reset HTJobScheduler on PowerSaverMode disabled
            HTTransmitterService.getInstance(context).getJobScheduler().onPowerSaverModeChanged(false);
        }
    }
}
