package io.hypertrack.lib.transmitter.service;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

import java.util.List;

import io.hypertrack.lib.common.util.HTLog;

/**
 * Created by ulhas on 18/05/16.
 */
/** package */ class LocationsDatabaseHelper extends SQLiteOpenHelper implements LocationDataSource {

    private static final String TAG = LocationsDatabaseHelper.class.getSimpleName();
    private static final String DATABASE_NAME = "io.hypertrack.lib.transmitter.locations.db";
    private static final int DATABASE_VERSION = 2;

    private static LocationsDatabaseHelper locationsDatabaseHelper;
    private SQLiteDatabase database;

    private LocationsDatabaseHelper(Context context) {
        super(context, DATABASE_NAME, null, DATABASE_VERSION);
        this.initializeDatabase();
    }

    private void initializeDatabase() {
        if (database == null)
            database = this.getWritableDatabase();
    }

    public static LocationsDatabaseHelper getInstance(Context context) {
        if (locationsDatabaseHelper == null) {
            locationsDatabaseHelper = new LocationsDatabaseHelper(context);
        }
        return locationsDatabaseHelper;
    }

    @Override
    public void onCreate(SQLiteDatabase db) {
        LocationTable.onCreate(db);
        HTLog.i(TAG, "LocationsDatabaseHelper onCreate called.");
    }

    @Override
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        LocationTable.onUpgrade(db, oldVersion, newVersion);
        HTLog.i(TAG, "LocationsDatabaseHelper onUpgrade called.");
    }

    public long getLocationCount() {
        // Initialize SQLiteDatabase if null
        initializeDatabase();

        long count = LocationTable.getCount(database);
        return count;
    }

    public void addLocation(GPSLocation location) {
        // Initialize SQLiteDatabase if null
        initializeDatabase();

        LocationTable.addLocation(database, location);
    }

    public void addLocations(List<GPSLocation> locationList) {
        // Initialize SQLiteDatabase if null
        initializeDatabase();

        LocationTable.addLocations(database, locationList);
    }

    public void deleteLocations(List<GPSLocation> locationsList) {
        // Initialize SQLiteDatabase if null
        initializeDatabase();

        LocationTable.deleteLocations(database, locationsList);
    }

    public void deleteAllLocations() {
        // Initialize SQLiteDatabase if null
        initializeDatabase();

        LocationTable.deleteAllLocations(database);
    }

    public void deleteAllLocationsOtherThanTripID(String tripID) {
        // Initialize SQLiteDatabase if null
        initializeDatabase();

        LocationTable.deleteLocationsOtherThanTripID(database, tripID);
    }

    public void deleteAllLocationsOtherThanDriverID(String driverID) {
        // Initialize SQLiteDatabase if null
        initializeDatabase();

        LocationTable.deleteLocationsOtherThanDriverID(database, driverID);
    }

    public List<GPSLocation> getLocationsForTripID(String tripID) {
        try {
            // Initialize SQLiteDatabase if null
            initializeDatabase();

            List<GPSLocation> locations;
            locations = LocationTable.getLocationsWithTripID(database, tripID);

            return locations;
        } catch (OutOfMemoryError e) {
            e.printStackTrace();
        } catch (Exception e) {
            HTLog.e(TAG, "Exception occurred while getLocationsForTripID: " + e);
        }

        return null;
    }

    public List<GPSLocation> getLocationsForDriverID(String driverID) {
        try {
            // Initialize SQLiteDatabase if null
            initializeDatabase();

            List<GPSLocation> locations;
            locations = LocationTable.getLocationsWithDriverID(database, driverID);

            return locations;
        } catch (OutOfMemoryError e) {
            e.printStackTrace();
        } catch (Exception e) {
            HTLog.e(TAG, "Exception occurred while getLocationsForDriverID: " + e);
        }

        return null;
    }
}
