package io.hypertrack.lib.transmitter.service;

import android.location.Location;

import java.util.Date;

import io.hypertrack.lib.common.util.DateTimeUtility;

/**
 * Created by ulhas on 17/05/16.
 */
/** package */ class PendingCompleteTrip {

    private String tripID;
    private String driverID;
    private String completionTime;
    private Location completionLocation;
    private Boolean completed;

    public String getTripID() {
        return tripID;
    }

    public void setTripID(String tripID) {
        this.tripID = tripID;
    }

    public Location getCompletionLocation() {
        return completionLocation;
    }

    public void setCompletionLocation(Location location) {
        this.completionLocation = location;
    }

    public Date getCompletionTime() {
        return DateTimeUtility.getFormattedDate(completionTime);
    }

    public void setCompletionTime(String completionTime) {
        this.completionTime = completionTime;
    }

    public Boolean isCompleted() {
        return completed;
    }

    public void setCompleted(Boolean completed) {
        this.completed = completed;
    }

    public PendingCompleteTrip(String tripID) {
        this.tripID = tripID;
    }

    public PendingCompleteTrip(String tripID, String driverID, Location location, Date completionDate) {
        this.tripID = tripID;
        this.driverID = driverID;
        this.completionLocation = location;
        this.completionTime = DateTimeUtility.getFormattedTime(completionDate);
    }

    @Override
    public int hashCode() {
        final int prime = 17;

        return (prime + ((tripID == null) ? 0 : tripID.hashCode()));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }

        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }

        if (tripID == null) {
            return false;
        }

        PendingCompleteTrip pendingCompleteTrip = (PendingCompleteTrip) o;

        if (pendingCompleteTrip.tripID == null) {
            return false;
        }

        return this.tripID.equalsIgnoreCase(pendingCompleteTrip.tripID);
    }
}
