package io.hypertrack.lib.transmitter.service;

import java.util.ArrayList;

import io.hypertrack.lib.common.model.HTDriverVehicleType;
import io.hypertrack.lib.common.model.HTLocation;
import io.hypertrack.lib.transmitter.model.HTTripParams;

/**
 * Created by piyush on 26/09/16.
 */
/** package */ class PendingStartTrip {

    private String tripID;
    private String driverID;
    private ArrayList<String> taskIDs;
    private boolean isAutoEnded;
    private boolean hasOrderedTasks;

    private String startTime;
    private HTLocation startLocation;
    private HTDriverVehicleType vehicleType;

    private Boolean started;

    public String getTripID() {
        return tripID;
    }

    public void setTripID(String tripID) {
        this.tripID = tripID;
    }

    public String getDriverID() {
        return driverID;
    }

    public void setDriverID(String driverID) {
        this.driverID = driverID;
    }

    public ArrayList<String> getTaskIDs() {
        return taskIDs;
    }

    public void setTaskIDs(ArrayList<String> taskIDs) {
        this.taskIDs = taskIDs;
    }

    public boolean isAutoEnded() {
        return isAutoEnded;
    }

    public void setAutoEnded(boolean autoEnded) {
        isAutoEnded = autoEnded;
    }

    public boolean isHasOrderedTasks() {
        return hasOrderedTasks;
    }

    public void setHasOrderedTasks(boolean hasOrderedTasks) {
        this.hasOrderedTasks = hasOrderedTasks;
    }

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public HTLocation getStartLocation() {
        return startLocation;
    }

    public void setStartLocation(HTLocation startLocation) {
        this.startLocation = startLocation;
    }

    public HTDriverVehicleType getVehicleType() {
        return vehicleType;
    }

    public void setVehicleType(HTDriverVehicleType vehicleType) {
        this.vehicleType = vehicleType;
    }

    public Boolean isStarted() {
        return started;
    }

    public void setStarted(Boolean started) {
        this.started = started;
    }

    public PendingStartTrip(String driverID) {
        this.driverID = driverID;
    }

    public PendingStartTrip(String driverID, ArrayList<String> taskIDs, boolean isAutoEnded, boolean hasOrderedTasks,
                            String startTime, HTLocation startLocation, HTDriverVehicleType vehicleType) {
        this.driverID = driverID;
        this.taskIDs = taskIDs;
        this.isAutoEnded = isAutoEnded;
        this.hasOrderedTasks = hasOrderedTasks;
        this.startTime = startTime;
        this.startLocation = startLocation;
        this.vehicleType = vehicleType;
    }

    public PendingStartTrip(String tripID, String driverID, ArrayList<String> taskIDs, boolean isAutoEnded, boolean hasOrderedTasks,
                            String startTime, HTLocation startLocation, HTDriverVehicleType vehicleType) {
        this(driverID, taskIDs, isAutoEnded, hasOrderedTasks, startTime, startLocation, vehicleType);
        this.tripID = tripID;
    }

    public PendingStartTrip(PendingStartTrip pendingStartTrip) {
        this.tripID = pendingStartTrip.getTripID();
        this.driverID = pendingStartTrip.getDriverID();
        this.taskIDs = pendingStartTrip.getTaskIDs();
        this.isAutoEnded = pendingStartTrip.isAutoEnded();
        this.hasOrderedTasks = pendingStartTrip.isHasOrderedTasks();
        this.startTime = pendingStartTrip.getStartTime();
        this.startLocation = pendingStartTrip.getStartLocation();
        this.vehicleType = pendingStartTrip.getVehicleType();
    }

    public PendingStartTrip(HTTripParams htTripParams) {
        this.tripID = htTripParams.getTripID();
        this.driverID = htTripParams.getDriverID();
        this.taskIDs = htTripParams.getTaskIDs();
        this.isAutoEnded = htTripParams.isAutoEnded();
        this.hasOrderedTasks = htTripParams.hasOrderedTasks();
        this.startTime = htTripParams.getStartTime();
        this.startLocation = htTripParams.getStartLocation();
        this.vehicleType = htTripParams.getVehicleType();
    }

    @Override
    public int hashCode() {
        final int prime = 17;

        return (prime + ((driverID == null) ? 0 : driverID.hashCode()));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }

        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }

        if (driverID == null) {
            return false;
        }

        PendingStartTrip pendingStartTrip = (PendingStartTrip) o;

        if (pendingStartTrip.driverID == null) {
            return false;
        }

        if ((tripID == null && pendingStartTrip.tripID != null) ||
                (tripID != null && pendingStartTrip.tripID == null))
            return false;

        if (tripID != null) {
            return this.tripID.equalsIgnoreCase(pendingStartTrip.tripID);

        } else {
            return this.driverID.equalsIgnoreCase(pendingStartTrip.driverID);
        }
    }
}
