package io.hypertrack.lib.transmitter.service;

import android.location.Location;

import java.util.Date;

import io.hypertrack.lib.common.util.DateTimeUtility;

/**
 * Created by ulhas on 10/05/16.
 */
/** package */ class PendingTask {

    private String taskID;
    private String tripID;
    private String driverID;
    private String completionTime;
    private Location completionLocation;
    private Boolean completed;

    public String getTaskID() {
        return taskID;
    }

    public void setTaskID(String taskID) {
        this.taskID = taskID;
    }

    public Location getCompletionLocation() {
        return completionLocation;
    }

    public void setCompletionLocation(Location completionLocation) {
        this.completionLocation = completionLocation;
    }

    public String getTripID() {
        return tripID;
    }

    public void setTripID(String tripID) {
        this.tripID = tripID;
    }

    public String getDriverID() {
        return driverID;
    }

    public void setDriverID(String driverID) {
        this.driverID = driverID;
    }

    public Date getCompletionTime() {
        return DateTimeUtility.getFormattedDate(completionTime);
    }

    public void setCompletionTime(String completionTime) {
        this.completionTime = completionTime;
    }

    public Boolean isCompleted() {
        return completed;
    }

    public void setCompleted(Boolean completed) {
        this.completed = completed;
    }

    public PendingTask(String taskID) {
        this.taskID = taskID;
    }

    public PendingTask(String taskID, Location completionLocation, String tripID, String driverID, Date completionDate) {
        this.taskID = taskID;
        this.completionLocation = completionLocation;
        this.tripID = tripID;
        this.driverID = driverID;
        this.completionTime = DateTimeUtility.getFormattedTime(completionDate);
    }

    @Override
    public int hashCode() {
        final int prime = 17;

        return (prime + ((taskID == null) ? 0 : taskID.hashCode()));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }

        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }

        if (taskID == null) {
            return false;
        }

        PendingTask task = (PendingTask) o;

        if (task.taskID == null) {
            return false;
        }

        return this.taskID.equalsIgnoreCase(task.taskID);
    }
}
