package io.hypertrack.lib.transmitter.service;

import android.content.Context;
import android.content.SharedPreferences;

import com.google.gson.Gson;

import io.hypertrack.lib.common.model.HTConstants;

/**
 * Created by ulhas on 10/05/16.
 */
/** package */ class PendingTripManager {

    private static final String PENDING_END_TRIP_PREFERENCE_KEY = "io.hypertrack.lib:SharedPreferencePendingEndTrip";

    private Context mContext;

    public PendingTripManager(Context context) {
        this.mContext = context;
    }

    public void setPendingEndTrip(PendingCompleteTrip pendingCompleteTrip) {
        if (pendingCompleteTrip == null) {
            return;
        }

        SharedPreferences.Editor editor = this.getEditor();

        Gson gson = new Gson();
        String serializedLocation = gson.toJson(pendingCompleteTrip);

        editor.putString(PENDING_END_TRIP_PREFERENCE_KEY, serializedLocation);
        editor.apply();
    }

    public PendingCompleteTrip getPendingEndTrip() {
        SharedPreferences preferences = this.mContext.getSharedPreferences(HTConstants.HT_SHARED_PREFERENCES_KEY, Context.MODE_PRIVATE);
        String locationString = preferences.getString(PENDING_END_TRIP_PREFERENCE_KEY, null);

        if (locationString == null) {
            return null;
        }

        Gson gson = new Gson();
        return gson.fromJson(locationString, PendingCompleteTrip.class);
    }

    public void clearPendingEndTrip() {
        SharedPreferences.Editor editor = this.getEditor();

        editor.remove(PENDING_END_TRIP_PREFERENCE_KEY);
        editor.apply();
    }

    private SharedPreferences.Editor getEditor() {
        SharedPreferences preferences = this.mContext.getSharedPreferences(HTConstants.HT_SHARED_PREFERENCES_KEY, Context.MODE_PRIVATE);
        return preferences.edit();
    }

    public void clearPendingTripOtherThanID(String tripID) {
        if (tripID == null) {
            return;
        }

        PendingCompleteTrip pendingCompleteTrip = this.getPendingEndTrip();
        if (pendingCompleteTrip == null) {
            return;
        }

        if (pendingCompleteTrip.getTripID() != null && !pendingCompleteTrip.getTripID().equalsIgnoreCase(tripID)) {
            this.clearPendingEndTrip();
        }
    }
}
