package io.hypertrack.lib.transmitter.service;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;

import io.hypertrack.lib.common.model.HTConstants;
import io.hypertrack.lib.common.util.HTLog;
import io.hypertrack.lib.transmitter.model.TransmitterConstants;

/**
 * Created by piyush on 07/08/16.
 */
/** package */ class PostDataToServer {

    private final static String TAG = PostDataToServer.class.getSimpleName();

    public static void post(Context context) {
         final String driverID = PostDataToServer.getDriverID(context);

        // Check if LocationService is live and restart the service, if applicable
        HTTransmitterService transmitterService = HTTransmitterService.getInstance(context);
        if (transmitterService.isDriverLive()) {
            transmitterService.restartLocationServiceIfNotActive();

            if (TextUtils.isEmpty(driverID)) {
                HTLog.e(TAG, "Error occurred while PostDataToServer: Driver is Live & still DriverID is null");
                return;
            }
        } else {
            // Driver is NOT Live, Remove CollectDeviceInfo PeriodicTask
            TransmissionManager.removeCollectDeviceInfoJob(context);

            if (TextUtils.isEmpty(driverID)) {
                HTLog.e(TAG, "Error occurred while PostDataToServer: DriverID is null");

                // NO Pending Data, Remove PostData PeriodicTask
                TransmissionManager.removePostDataJob(context);

                // Disconnect MQTT Client
                // NetworkManager.getInstance(context).disconnectMQTTClient(null);
                return;
            }

            // Check for any Pending data to be pushed to Server
            if (!transmitterService.getTransmissionManager().hasPendingData(driverID)) {
                HTLog.i(TAG, "No pending data available. Removing PeriodicTasks");

                // NO Pending Data, Remove PostData PeriodicTask
                TransmissionManager.removePostDataJob(context);

                // Disconnect MQTT Client
                // NetworkManager.getInstance(context).disconnectMQTTClient(null);
                return;
            }
        }

        // Post Data To Server
        transmitterService.getTransmissionManager().postDriverDataToServer(driverID);
        transmitterService.getTransmissionManager().postDeviceInfoToServer(driverID);

        PostDataToServer.setLastPostToServerTime(context);
    }

    public static String getDriverID(Context context) {
        SharedPreferences sharedpreferences = context.getSharedPreferences(HTConstants.HT_SHARED_PREFERENCES_KEY, Context.MODE_PRIVATE);
        return sharedpreferences.getString(TransmitterConstants.HT_SHARED_PREFERENCE_POST_DATA_TASK_DRIVER_ID_KEY, null);
    }

    public static void setLastPostToServerTime(Context context) {
        SharedPreferences sharedpreferences = context.getSharedPreferences(HTConstants.HT_SHARED_PREFERENCES_KEY, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sharedpreferences.edit();
        editor.putLong(TransmitterConstants.HT_SHARED_PREFERENCE_PERIODIC_TASK_LAST_UPDATED_TIME, System.currentTimeMillis());
        editor.apply();
    }

    public static Long getLastPostToServerTime(Context context) {
        SharedPreferences sharedpreferences = context.getSharedPreferences(HTConstants.HT_SHARED_PREFERENCES_KEY, Context.MODE_PRIVATE);
        long lastUpdatedTime = sharedpreferences.getLong(TransmitterConstants.HT_SHARED_PREFERENCE_PERIODIC_TASK_LAST_UPDATED_TIME, Long.MIN_VALUE);

        return (lastUpdatedTime != Long.MIN_VALUE) ? lastUpdatedTime : null;
    }

    public static void clearLastPostToServerTime(Context context) {
        SharedPreferences sharedpreferences = context.getSharedPreferences(HTConstants.HT_SHARED_PREFERENCES_KEY, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = sharedpreferences.edit();
        editor.remove(TransmitterConstants.HT_SHARED_PREFERENCE_PERIODIC_TASK_LAST_UPDATED_TIME);
        editor.apply();
    }
}
