package io.hypertrack.lib.transmitter.service;

import android.app.IntentService;
import android.content.Intent;
import android.text.TextUtils;

/**
 * Created by piyush on 15/11/16.
 */
public class SDKConnectionChangedService extends IntentService {
    public static final String SDK_CONNECTION_ONLINE_KEY = "io.hypertrack.lib.transmitter.connection_online";

    public SDKConnectionChangedService() {
        super(SDKConnectionChangedService.class.getSimpleName());
    }

    @Override
    protected void onHandleIntent(Intent intent) {
        if (intent == null)
            return;

        final HTTransmitterService transmitterService = HTTransmitterService.getInstance(getApplicationContext());

        // Check if Internet got connected or disconnected
        if (intent.getBooleanExtra(SDK_CONNECTION_ONLINE_KEY, false)) {
            // Reconnect MQTT on successful connection changed
            String driverID = transmitterService.getDriverID();
            if (!TextUtils.isEmpty(driverID) && !transmitterService.isDriverConnected(driverID)) {
                HTTransmitterService.connectDriver(getApplicationContext(), driverID);
            }

        } else if (transmitterService.isDriverLive()){
            // Get Offline SDKControls
            SDKControlsManager sdkControlsManager = new SDKControlsManager(getApplicationContext());
            sdkControlsManager.setOfflineSDKControls(new UpdateControlsCallback() {
                @Override
                public void OnControlsUpdate(boolean restartLocation, boolean restartPeriodicTask) {
                    // Re-initiate DriverActivity, if SDKControls have been updated
                    if (restartLocation || restartPeriodicTask) {
                        transmitterService.getTransmissionManager().startDriverActivity(restartLocation);
                    }
                }

                @Override
                public void OnControlsDriverNotActive() {
                    // do nothing
                }
            });
        }
    }
}
