package io.hypertrack.lib.transmitter.service;

import android.location.Location;

import com.google.gson.annotations.SerializedName;

import java.util.Date;

import io.hypertrack.lib.common.model.HTLocation;

/**
 * Created by ulhas on 08/03/16.
 */
/** package */ class TaskCompletionRequest {

    @SerializedName("completion_location")
    private HTLocation completionLocation;

    @SerializedName("completion_time")
    private Date completionTime;

    public Date getCompletionTime() {
        return completionTime;
    }

    public void setCompletionTime(Date completionTime) {
        this.completionTime = completionTime;
    }

    public HTLocation getCompletionLocation() {
        return completionLocation;
    }

    public void setCompletionLocation(HTLocation completionLocation) {
        this.completionLocation = completionLocation;
    }

    @Override
    public String toString() {
        return "TaskCompletionRequest{" +
                "completionLocation=" + (completionLocation != null ? completionLocation : "") +
                ", completionTime=" + completionTime +
                '}';
    }

    public TaskCompletionRequest(Location location, Date completionTime) {
        if (location != null) {
            this.completionLocation = new HTLocation(location);
        }

        this.completionTime = completionTime;
    }
}
