package io.hypertrack.lib.transmitter.service;

import android.app.IntentService;
import android.content.Intent;
import android.os.Bundle;

import io.hypertrack.lib.common.scheduler.HTJobScheduler;

/**
 * Created by piyush on 01/11/16.
 */
public class TransmitterAlarmReceiverService extends IntentService {

    public TransmitterAlarmReceiverService() {
        super(TransmitterAlarmReceiverService.class.getSimpleName());
    }

    public TransmitterAlarmReceiverService(String name) {
        super(name);
    }

    @Override
    protected void onHandleIntent(Intent intent) {

        HTTransmitterService transmitterService = HTTransmitterService.getInstance(getApplicationContext());
        if (intent != null && intent.getExtras() != null) {

            Bundle bundle = intent.getExtras();
            final Integer jobID = bundle.getInt(HTJobScheduler.ALARM_JOB_ID_KEY, -1);
            transmitterService.getJobScheduler().onAlarmJobScheduled(jobID);
        }
    }
}
