package io.hypertrack.lib.transmitter.service;

import com.google.android.gms.gcm.GcmNetworkManager;
import com.google.android.gms.gcm.GcmTaskService;
import com.google.android.gms.gcm.TaskParams;

import io.hypertrack.lib.common.util.HTLog;

/**
 * Created by piyush on 09/08/16.
 */
public class TransmitterJSPeriodicTask extends GcmTaskService {

    private final static String TAG = TransmitterJSPeriodicTask.class.getSimpleName();

    @Override
    public void onInitializeTasks() {
        super.onInitializeTasks();

        HTLog.i(TAG, "TransmitterJobScheduler PeriodicTask.onInitializeTasks called");

        // Check if LocationService is live and restart the service, if applicable
        HTTransmitterService transmitterService = HTTransmitterService.getInstance(getApplicationContext());
        if (transmitterService.isDriverLive()) {
            transmitterService.restartLocationServiceIfNotActive();
        }
    }

    @Override
    public int onRunTask(TaskParams taskParams) {
        HTLog.i(TAG, "TransmitterJobScheduler PeriodicTask.onRunTask called");

        HTTransmitterService.getInstance(getApplicationContext()).getJobScheduler()
                .onPeriodicTaskJobScheduled(taskParams.getTag(), taskParams.getExtras());
        return GcmNetworkManager.RESULT_SUCCESS;
    }
}
