package io.hypertrack.lib.transmitter.service;

import android.Manifest;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageManager;
import android.location.Location;
import android.location.LocationManager;
import android.os.Build;
import android.provider.Settings;

import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;

import io.hypertrack.lib.common.util.HTLog;

/**
 * Created by ulhas on 09/05/16.
 */

/** package */ class ValidationUtility {

    private static final String TAG = ValidationUtility.class.getSimpleName();

    private static boolean isGPSEnabled(Context context) {
        try {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
                ContentResolver contentResolver = context.getContentResolver();
                // Find out what the settings say about which providers are enabled
                int mode = Settings.Secure.getInt(
                        contentResolver, Settings.Secure.LOCATION_MODE, Settings.Secure.LOCATION_MODE_OFF);
                return (mode != Settings.Secure.LOCATION_MODE_OFF && mode == Settings.Secure.LOCATION_MODE_HIGH_ACCURACY);

            } else {
                LocationManager locationManager = (LocationManager) context.getSystemService(Context.LOCATION_SERVICE);
                if (locationManager.isProviderEnabled(LocationManager.GPS_PROVIDER) &&
                        locationManager.isProviderEnabled(LocationManager.NETWORK_PROVIDER)) {
                    return true;
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            HTLog.e(TAG, "Exception occurred while isGPSEnabled: " + e);
        }

        return false;
    }

    private static boolean arePermissionsEnabled(Context context) {
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.M) {
            return true;
        }

        return (context.checkSelfPermission(Manifest.permission.ACCESS_FINE_LOCATION) == PackageManager.PERMISSION_GRANTED);
    }

    private static int isPlayServicesAvailable(Context context) {
        return GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(context);
    }

    public static Exception getValidationException(Context context) {
        int result = ValidationUtility.isPlayServicesAvailable(context);
        if (result != ConnectionResult.SUCCESS) {
            return new IllegalStateException("Cannot start trip. Please update play services");
        }

        if (!ValidationUtility.isGPSEnabled(context)) {
            return new IllegalArgumentException("Please verify Location Settings. Have you enabled Location and set Location Mode to High Accuracy ?");
        }

        if (!ValidationUtility.arePermissionsEnabled(context)) {
            return new IllegalStateException("Please verify permissions. Have you enabled the required permissions ?");
        }

        return null;
    }

    public static Location getValidatedLocation(Location location) {
        if (location != null && location.getLongitude() != 0.0 && location.getLatitude() != 0.0) {
            return location;
        }

        return null;
    }
}
