/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.text.TextUtils;
import com.hyphenate.chat.EMBase;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.chat.adapter.EMAConversation;
import com.hyphenate.chat.adapter.message.EMAMessage;
import com.hyphenate.util.EMLog;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class EMConversation
extends EMBase<EMAConversation> {
    private static final String TAG = "conversation";
    private static final int LIST_SIZE = 512;

    EMConversation(EMAConversation conversation) {
        this.emaObject = conversation;
    }

    public String conversationId() {
        return ((EMAConversation)this.emaObject).conversationId();
    }

    public EMConversationType getType() {
        EMAConversation.EMAConversationType eMAConversationType = ((EMAConversation)this.emaObject)._getType();
        if (eMAConversationType == EMAConversation.EMAConversationType.CHAT) {
            return EMConversationType.Chat;
        }
        if (eMAConversationType == EMAConversation.EMAConversationType.GROUPCHAT) {
            return EMConversationType.GroupChat;
        }
        if (eMAConversationType == EMAConversation.EMAConversationType.CHATROOM) {
            return EMConversationType.ChatRoom;
        }
        if (eMAConversationType == EMAConversation.EMAConversationType.DISCUSSIONGROUP) {
            return EMConversationType.DiscussionGroup;
        }
        if (eMAConversationType == EMAConversation.EMAConversationType.HELPDESK) {
            return EMConversationType.HelpDesk;
        }
        return EMConversationType.Chat;
    }

    public int getUnreadMsgCount() {
        return ((EMAConversation)this.emaObject).unreadMessagesCount();
    }

    public void markAllMessagesAsRead() {
        ((EMAConversation)this.emaObject).markAllMessagesAsRead(true);
    }

    public int getAllMsgCount() {
        return ((EMAConversation)this.emaObject).messagesCount();
    }

    public boolean isChatThread() {
        return ((EMAConversation)this.emaObject).isChatThread();
    }

    public List<EMMessage> loadMoreMsgFromDB(String startMsgId, int pageSize) {
        return this.loadMoreMsgFromDB(startMsgId, pageSize, EMSearchDirection.UP);
    }

    public List<EMMessage> loadMoreMsgFromDB(String startMsgId, int pageSize, EMSearchDirection direction) {
        EMAConversation.EMASearchDirection eMASearchDirection = direction == EMSearchDirection.UP ? EMAConversation.EMASearchDirection.UP : EMAConversation.EMASearchDirection.DOWN;
        List<EMAMessage> list = ((EMAConversation)this.emaObject).loadMoreMessages(startMsgId, pageSize, eMASearchDirection);
        ArrayList<EMMessage> arrayList = new ArrayList<EMMessage>();
        for (EMAMessage eMAMessage : list) {
            if (eMAMessage == null) continue;
            arrayList.add(new EMMessage(eMAMessage));
        }
        this.getCache().addMessages(arrayList);
        return arrayList;
    }

    public List<EMMessage> searchMsgFromDB(long timeStamp, int maxCount, EMSearchDirection direction) {
        EMAConversation.EMASearchDirection eMASearchDirection = direction == EMSearchDirection.UP ? EMAConversation.EMASearchDirection.UP : EMAConversation.EMASearchDirection.DOWN;
        List<EMAMessage> list = ((EMAConversation)this.emaObject).searchMessages(timeStamp, maxCount, eMASearchDirection);
        AbstractList abstractList = list.size() > 512 ? new LinkedList() : new ArrayList();
        for (EMAMessage eMAMessage : list) {
            if (eMAMessage == null) continue;
            abstractList.add((EMMessage)new EMMessage(eMAMessage));
        }
        return abstractList;
    }

    public List<EMMessage> searchMsgFromDB(EMMessage.Type type, long timeStamp, int maxCount, String from, EMSearchDirection direction) {
        EMAConversation.EMASearchDirection eMASearchDirection = direction == EMSearchDirection.UP ? EMAConversation.EMASearchDirection.UP : EMAConversation.EMASearchDirection.DOWN;
        List<EMAMessage> list = ((EMAConversation)this.emaObject).searchMessages(type.ordinal(), timeStamp, maxCount, from, eMASearchDirection);
        AbstractList abstractList = list.size() > 512 ? new LinkedList() : new ArrayList();
        for (EMAMessage eMAMessage : list) {
            if (eMAMessage == null) continue;
            abstractList.add((EMMessage)new EMMessage(eMAMessage));
        }
        return abstractList;
    }

    public List<EMMessage> searchMsgFromDB(String keywords, long timeStamp, int maxCount, String from, EMSearchDirection direction) {
        EMAConversation.EMASearchDirection eMASearchDirection = direction == EMSearchDirection.UP ? EMAConversation.EMASearchDirection.UP : EMAConversation.EMASearchDirection.DOWN;
        List<EMAMessage> list = ((EMAConversation)this.emaObject).searchMessages(keywords, timeStamp, maxCount, from, eMASearchDirection);
        AbstractList abstractList = list.size() > 512 ? new LinkedList() : new ArrayList();
        for (EMAMessage eMAMessage : list) {
            if (eMAMessage == null) continue;
            abstractList.add((EMMessage)new EMMessage(eMAMessage));
        }
        return abstractList;
    }

    public List<EMMessage> searchMsgFromDB(long startTimeStamp, long endTimeStamp, int maxCount) {
        List<EMAMessage> list = ((EMAConversation)this.emaObject).searchMessages(startTimeStamp, endTimeStamp, maxCount);
        AbstractList abstractList = list.size() > 512 ? new LinkedList() : new ArrayList();
        for (EMAMessage eMAMessage : list) {
            if (eMAMessage == null) continue;
            abstractList.add((EMMessage)new EMMessage(eMAMessage));
        }
        return abstractList;
    }

    public List<EMMessage> searchCustomMsgFromDB(String keywords, long timeStamp, int maxCount, String from, EMSearchDirection direction) {
        EMAConversation.EMASearchDirection eMASearchDirection = direction == EMSearchDirection.UP ? EMAConversation.EMASearchDirection.UP : EMAConversation.EMASearchDirection.DOWN;
        List<EMAMessage> list = ((EMAConversation)this.emaObject).searchCustomMessages(keywords, timeStamp, maxCount, from, eMASearchDirection);
        AbstractList abstractList = list.size() > 512 ? new LinkedList() : new ArrayList();
        for (EMAMessage eMAMessage : list) {
            if (eMAMessage == null) continue;
            abstractList.add((EMMessage)new EMMessage(eMAMessage));
        }
        return abstractList;
    }

    public EMMessage getMessage(String messageId, boolean markAsRead) {
        EMMessage eMMessage = this.getCache().getMessage(messageId);
        if (eMMessage == null) {
            EMAMessage eMAMessage = ((EMAConversation)this.emaObject).loadMessage(messageId);
            if (eMAMessage == null) {
                return null;
            }
            eMMessage = new EMMessage(eMAMessage);
        }
        ((EMAConversation)this.emaObject).markMessageAsRead(messageId, markAsRead);
        return eMMessage;
    }

    public void markMessageAsRead(String messageId) {
        ((EMAConversation)this.emaObject).markMessageAsRead(messageId, true);
    }

    public List<EMMessage> getAllMessages() {
        if (this.getCache().isEmpty()) {
            EMAMessage eMAMessage = ((EMAConversation)this.emaObject).latestMessage();
            ArrayList<EMMessage> arrayList = new ArrayList<EMMessage>();
            if (eMAMessage != null) {
                arrayList.add(new EMMessage(eMAMessage));
            }
            this.getCache().addMessages(arrayList);
        }
        return this.getCache().getAllMessages();
    }

    public void removeMessage(String messageId) {
        EMLog.d(TAG, "remove msg from conversation: " + messageId);
        ((EMAConversation)this.emaObject)._removeMessage(messageId);
        this.getCache().removeMessage(messageId);
    }

    public EMMessage getLastMessage() {
        if (this.getCache().isEmpty()) {
            EMAMessage eMAMessage = ((EMAConversation)this.emaObject).latestMessage();
            EMMessage eMMessage = eMAMessage == null ? null : new EMMessage(eMAMessage);
            this.getCache().addMessage(eMMessage);
            return eMMessage;
        }
        return this.getCache().getLastMessage();
    }

    public EMMessage getLatestMessageFromOthers() {
        EMAMessage eMAMessage = ((EMAConversation)this.emaObject).latestMessageFromOthers();
        EMMessage eMMessage = eMAMessage == null ? null : new EMMessage(eMAMessage);
        this.getCache().addMessage(eMMessage);
        return eMMessage;
    }

    public void clear() {
        this.getCache().clear();
    }

    public void clearAllMessages() {
        ((EMAConversation)this.emaObject).clearAllMessages();
        this.getCache().clear();
    }

    public void setExtField(String ext) {
        if (!this.isChatThread()) {
            ((EMAConversation)this.emaObject)._setExtField(ext);
        }
    }

    public String getExtField() {
        return ((EMAConversation)this.emaObject).extField();
    }

    public static EMConversationType msgType2ConversationType(String id, EMMessage.ChatType type) {
        switch (type) {
            case GroupChat: {
                return EMConversationType.GroupChat;
            }
            case ChatRoom: {
                return EMConversationType.ChatRoom;
            }
        }
        return EMConversationType.Chat;
    }

    public boolean isGroup() {
        EMConversationType eMConversationType = this.getType();
        return !this.isChatThread() && (eMConversationType == EMConversationType.GroupChat || eMConversationType == EMConversationType.ChatRoom);
    }

    public boolean insertMessage(EMMessage msg) {
        boolean bl = ((EMAConversation)this.emaObject).insertMessage((EMAMessage)msg.emaObject);
        if (bl) {
            this.getCache().addMessage(msg);
        }
        return bl;
    }

    public boolean appendMessage(EMMessage msg) {
        boolean bl = ((EMAConversation)this.emaObject).appendMessage((EMAMessage)msg.emaObject);
        if (bl) {
            this.getCache().addMessage(msg);
        }
        return bl;
    }

    public boolean updateMessage(EMMessage msg) {
        boolean bl = ((EMAConversation)this.emaObject).updateMessage((EMAMessage)msg.emaObject);
        if (bl) {
            this.getCache().addMessage(msg);
        }
        return bl;
    }

    public String getMessageAttachmentPath() {
        String string = EMClient.getInstance().getChatConfigPrivate().E();
        return string + "/" + EMClient.getInstance().getCurrentUser() + "/" + this.conversationId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MessageCache getCache() {
        MessageCache messageCache;
        Map<String, MessageCache> map = EMClient.getInstance().chatManager().caches;
        synchronized (map) {
            messageCache = EMClient.getInstance().chatManager().caches.get(((EMAConversation)this.emaObject).conversationId());
            if (messageCache == null) {
                messageCache = new MessageCache();
            }
            EMClient.getInstance().chatManager().caches.put(((EMAConversation)this.emaObject).conversationId(), messageCache);
        }
        return messageCache;
    }

    static class MessageCache {
        TreeMap<Long, Object> sortedMessages = new TreeMap(new MessageComparator());
        Map<String, EMMessage> messages = new HashMap<String, EMMessage>();
        Map<String, Long> idTimeMap = new HashMap<String, Long>();
        boolean hasDuplicateTime = false;
        final boolean sortByServerTime = EMClient.getInstance().getChatConfigPrivate().b().isSortMessageByServerTime();

        MessageCache() {
        }

        public synchronized EMMessage getMessage(String msgId) {
            if (msgId == null || msgId.isEmpty()) {
                return null;
            }
            return this.messages.get(msgId);
        }

        public synchronized void addMessages(List<EMMessage> msgs) {
            for (EMMessage eMMessage : msgs) {
                this.addMessage(eMMessage);
            }
        }

        public synchronized void addMessage(EMMessage msg) {
            long l;
            if (msg == null || msg.emaObject == null || msg.getMsgTime() == 0L || msg.getMsgTime() == -1L || msg.getMsgId() == null || msg.getMsgId().isEmpty() || msg.getType() == EMMessage.Type.CMD) {
                return;
            }
            String string = msg.getMsgId();
            Iterator<EMMessage> iterator = this.messages.values().iterator();
            while (iterator.hasNext()) {
                EMMessage eMMessage = iterator.next();
                if (!TextUtils.equals((CharSequence)string, (CharSequence)eMMessage.getMsgId())) continue;
                long l2 = this.idTimeMap.get(string);
                this.sortedMessages.remove(l2);
                iterator.remove();
                this.idTimeMap.remove(string);
            }
            long l3 = l = this.sortByServerTime ? msg.getMsgTime() : msg.localTime();
            if (this.sortedMessages.containsKey(l)) {
                this.hasDuplicateTime = true;
                Object object = this.sortedMessages.get(l);
                if (object != null) {
                    if (object instanceof EMMessage) {
                        LinkedList<EMMessage> linkedList = new LinkedList<EMMessage>();
                        linkedList.add((EMMessage)object);
                        linkedList.add(msg);
                        this.sortedMessages.put(l, linkedList);
                    } else if (object instanceof List) {
                        List list = (List)object;
                        list.add(msg);
                    }
                }
            } else {
                this.sortedMessages.put(l, msg);
            }
            this.messages.put(string, msg);
            this.idTimeMap.put(string, l);
        }

        public synchronized void removeMessage(String msgId) {
            if (msgId == null || msgId.isEmpty()) {
                return;
            }
            EMMessage eMMessage = this.messages.get(msgId);
            if (eMMessage != null) {
                Long l = this.idTimeMap.get(msgId);
                if (l != null) {
                    if (this.hasDuplicateTime && this.sortedMessages.containsKey(l)) {
                        Object object = this.sortedMessages.get(l);
                        if (object != null && object instanceof List) {
                            List list = (List)object;
                            for (EMMessage eMMessage2 : list) {
                                if (eMMessage2 == null || eMMessage2.getMsgId() == null || !eMMessage2.getMsgId().equals(msgId)) continue;
                                list.remove(eMMessage2);
                                break;
                            }
                        } else {
                            this.sortedMessages.remove(l);
                        }
                    } else {
                        this.sortedMessages.remove(l);
                    }
                    this.idTimeMap.remove(msgId);
                }
                this.messages.remove(msgId);
            }
        }

        public synchronized List<EMMessage> getAllMessages() {
            ArrayList<EMMessage> arrayList = new ArrayList<EMMessage>();
            if (!this.hasDuplicateTime) {
                for (Object object : this.sortedMessages.values()) {
                    arrayList.add((EMMessage)object);
                }
            } else {
                for (Object object : this.sortedMessages.values()) {
                    if (object == null) continue;
                    if (object instanceof List) {
                        arrayList.addAll((List)object);
                        continue;
                    }
                    arrayList.add((EMMessage)object);
                }
            }
            return arrayList;
        }

        public synchronized EMMessage getLastMessage() {
            if (this.sortedMessages.isEmpty()) {
                return null;
            }
            Object object = this.sortedMessages.lastEntry().getValue();
            if (object == null) {
                return null;
            }
            if (object instanceof EMMessage) {
                return (EMMessage)object;
            }
            if (object instanceof List) {
                List list = (List)object;
                if (list.size() > 0) {
                    return (EMMessage)list.get(list.size() - 1);
                }
                return null;
            }
            return null;
        }

        public synchronized void clear() {
            this.sortedMessages.clear();
            this.messages.clear();
            this.idTimeMap.clear();
        }

        public synchronized boolean isEmpty() {
            return this.sortedMessages.isEmpty();
        }

        class MessageComparator
        implements Comparator<Long> {
            MessageComparator() {
            }

            @Override
            public int compare(Long time0, Long time1) {
                long l = time0 - time1;
                if (l > 0L) {
                    return 1;
                }
                if (l == 0L) {
                    return 0;
                }
                return -1;
            }
        }
    }

    public static enum EMSearchDirection {
        UP,
        DOWN;

    }

    public static enum EMConversationType {
        Chat,
        GroupChat,
        ChatRoom,
        DiscussionGroup,
        HelpDesk;

    }
}

