/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import com.hyphenate.EMCallBack;
import com.hyphenate.EMGroupChangeListener;
import com.hyphenate.EMValueCallBack;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMCursorResult;
import com.hyphenate.chat.EMGroup;
import com.hyphenate.chat.EMGroupInfo;
import com.hyphenate.chat.EMGroupOptions;
import com.hyphenate.chat.EMMucSharedFile;
import com.hyphenate.chat.adapter.EMACallback;
import com.hyphenate.chat.adapter.EMAError;
import com.hyphenate.chat.adapter.EMAGroup;
import com.hyphenate.chat.adapter.EMAGroupManager;
import com.hyphenate.chat.adapter.EMAGroupManagerListener;
import com.hyphenate.chat.adapter.EMAGroupSetting;
import com.hyphenate.chat.adapter.EMAMucShareFile;
import com.hyphenate.exceptions.HyphenateException;
import com.hyphenate.util.EMLog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class EMGroupManager {
    EMAGroupManager emaObject;
    private static String TAG = "group";
    List<EMGroupChangeListener> groupChangeListeners;
    EMAGroupManagerListener listenerImpl = new EMAGroupManagerListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceiveInviteFromGroup(String groupId, String groupName, String inviter, String inviteMessage) {
            List<EMGroupChangeListener> list = EMGroupManager.this.groupChangeListeners;
            synchronized (list) {
                try {
                    for (EMGroupChangeListener eMGroupChangeListener : EMGroupManager.this.groupChangeListeners) {
                        eMGroupChangeListener.onInvitationReceived(groupId, groupName, inviter, inviteMessage);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceiveInviteAcceptionFromGroup(EMAGroup group, String invitee) {
            List<EMGroupChangeListener> list = EMGroupManager.this.groupChangeListeners;
            synchronized (list) {
                try {
                    for (EMGroupChangeListener eMGroupChangeListener : EMGroupManager.this.groupChangeListeners) {
                        eMGroupChangeListener.onInvitationAccepted(group.groupId(), invitee, "");
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceiveInviteDeclineFromGroup(EMAGroup group, String invitee, String reason) {
            List<EMGroupChangeListener> list = EMGroupManager.this.groupChangeListeners;
            synchronized (list) {
                try {
                    for (EMGroupChangeListener eMGroupChangeListener : EMGroupManager.this.groupChangeListeners) {
                        eMGroupChangeListener.onInvitationDeclined(group.groupId(), invitee, "");
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAutoAcceptInvitationFromGroup(EMAGroup group, String inviter, String inviteMessage) {
            List<EMGroupChangeListener> list = EMGroupManager.this.groupChangeListeners;
            synchronized (list) {
                try {
                    for (EMGroupChangeListener eMGroupChangeListener : EMGroupManager.this.groupChangeListeners) {
                        eMGroupChangeListener.onAutoAcceptInvitationFromGroup(group.groupId(), inviter, inviteMessage);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLeaveGroup(EMAGroup group, int reason) {
            EMClient.getInstance().chatManager().caches.remove(group.groupId());
            List<EMGroupChangeListener> list = EMGroupManager.this.groupChangeListeners;
            synchronized (list) {
                try {
                    for (EMGroupChangeListener eMGroupChangeListener : EMGroupManager.this.groupChangeListeners) {
                        if (reason == EMAGroup.EMGroupLeaveReason.BE_KICKED.ordinal()) {
                            eMGroupChangeListener.onUserRemoved(group.groupId(), group.groupSubject());
                            continue;
                        }
                        eMGroupChangeListener.onGroupDestroyed(group.groupId(), group.groupSubject());
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceiveJoinGroupApplication(EMAGroup group, String from, String message) {
            List<EMGroupChangeListener> list = EMGroupManager.this.groupChangeListeners;
            synchronized (list) {
                try {
                    for (EMGroupChangeListener eMGroupChangeListener : EMGroupManager.this.groupChangeListeners) {
                        eMGroupChangeListener.onRequestToJoinReceived(group.groupId(), group.groupSubject(), from, message);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceiveAcceptionFromGroup(EMAGroup group) {
            List<EMGroupChangeListener> list = EMGroupManager.this.groupChangeListeners;
            synchronized (list) {
                try {
                    for (EMGroupChangeListener eMGroupChangeListener : EMGroupManager.this.groupChangeListeners) {
                        eMGroupChangeListener.onRequestToJoinAccepted(group.groupId(), group.groupSubject(), group.getOwner());
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceiveRejectionFromGroup(String groupId, String reason) {
            EMGroup eMGroup = EMGroupManager.this.getGroup(groupId);
            String string = eMGroup == null ? "" : eMGroup.groupSubject();
            String string2 = eMGroup == null ? "" : eMGroup.getOwner();
            List<EMGroupChangeListener> list = EMGroupManager.this.groupChangeListeners;
            synchronized (list) {
                try {
                    for (EMGroupChangeListener eMGroupChangeListener : EMGroupManager.this.groupChangeListeners) {
                        eMGroupChangeListener.onRequestToJoinDeclined(groupId, string, string2, reason);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        @Override
        public void onUpdateMyGroupList(List<EMAGroup> groups) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAddMutesFromGroup(EMAGroup group, List<String> muteMembers, long muteExpire) {
            List<EMGroupChangeListener> list = EMGroupManager.this.groupChangeListeners;
            synchronized (list) {
                try {
                    for (EMGroupChangeListener eMGroupChangeListener : EMGroupManager.this.groupChangeListeners) {
                        eMGroupChangeListener.onMuteListAdded(group.groupId(), muteMembers, muteExpire);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRemoveMutesFromGroup(EMAGroup group, List<String> banPostList) {
            List<EMGroupChangeListener> list = EMGroupManager.this.groupChangeListeners;
            synchronized (list) {
                try {
                    for (EMGroupChangeListener eMGroupChangeListener : EMGroupManager.this.groupChangeListeners) {
                        eMGroupChangeListener.onMuteListRemoved(group.groupId(), banPostList);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onWhiteListAdded(EMAGroup group, List<String> members) {
            List<EMGroupChangeListener> list = EMGroupManager.this.groupChangeListeners;
            synchronized (list) {
                try {
                    for (EMGroupChangeListener eMGroupChangeListener : EMGroupManager.this.groupChangeListeners) {
                        eMGroupChangeListener.onWhiteListAdded(group.groupId(), members);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onWhiteListRemoved(EMAGroup group, List<String> members) {
            List<EMGroupChangeListener> list = EMGroupManager.this.groupChangeListeners;
            synchronized (list) {
                try {
                    for (EMGroupChangeListener eMGroupChangeListener : EMGroupManager.this.groupChangeListeners) {
                        eMGroupChangeListener.onWhiteListRemoved(group.groupId(), members);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAllMemberMuteStateChanged(EMAGroup group, boolean isMuted) {
            List<EMGroupChangeListener> list = EMGroupManager.this.groupChangeListeners;
            synchronized (list) {
                try {
                    for (EMGroupChangeListener eMGroupChangeListener : EMGroupManager.this.groupChangeListeners) {
                        eMGroupChangeListener.onAllMemberMuteStateChanged(group.groupId(), isMuted);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAddAdminFromGroup(EMAGroup group, String admin) {
            List<EMGroupChangeListener> list = EMGroupManager.this.groupChangeListeners;
            synchronized (list) {
                try {
                    for (EMGroupChangeListener eMGroupChangeListener : EMGroupManager.this.groupChangeListeners) {
                        eMGroupChangeListener.onAdminAdded(group.groupId(), admin);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRemoveAdminFromGroup(EMAGroup group, String admin) {
            List<EMGroupChangeListener> list = EMGroupManager.this.groupChangeListeners;
            synchronized (list) {
                try {
                    for (EMGroupChangeListener eMGroupChangeListener : EMGroupManager.this.groupChangeListeners) {
                        eMGroupChangeListener.onAdminRemoved(group.groupId(), admin);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAssignOwnerFromGroup(EMAGroup group, String newOwner, String oldOwner) {
            List<EMGroupChangeListener> list = EMGroupManager.this.groupChangeListeners;
            synchronized (list) {
                try {
                    for (EMGroupChangeListener eMGroupChangeListener : EMGroupManager.this.groupChangeListeners) {
                        eMGroupChangeListener.onOwnerChanged(group.groupId(), newOwner, oldOwner);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMemberJoined(EMAGroup group, String member) {
            List<EMGroupChangeListener> list = EMGroupManager.this.groupChangeListeners;
            synchronized (list) {
                try {
                    for (EMGroupChangeListener eMGroupChangeListener : EMGroupManager.this.groupChangeListeners) {
                        eMGroupChangeListener.onMemberJoined(group.groupId(), member);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMemberExited(EMAGroup group, String member) {
            List<EMGroupChangeListener> list = EMGroupManager.this.groupChangeListeners;
            synchronized (list) {
                try {
                    for (EMGroupChangeListener eMGroupChangeListener : EMGroupManager.this.groupChangeListeners) {
                        eMGroupChangeListener.onMemberExited(group.groupId(), member);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAnnouncementChanged(EMAGroup group, String announcement) {
            List<EMGroupChangeListener> list = EMGroupManager.this.groupChangeListeners;
            synchronized (list) {
                try {
                    for (EMGroupChangeListener eMGroupChangeListener : EMGroupManager.this.groupChangeListeners) {
                        eMGroupChangeListener.onAnnouncementChanged(group.groupId(), announcement);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onUploadShareFileFromGroup(EMAGroup group, EMAMucShareFile shareFile) {
            List<EMGroupChangeListener> list = EMGroupManager.this.groupChangeListeners;
            synchronized (list) {
                try {
                    for (EMGroupChangeListener eMGroupChangeListener : EMGroupManager.this.groupChangeListeners) {
                        eMGroupChangeListener.onSharedFileAdded(group.groupId(), new EMMucSharedFile(shareFile));
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDeleteShareFileFromGroup(EMAGroup group, String fileId) {
            List<EMGroupChangeListener> list = EMGroupManager.this.groupChangeListeners;
            synchronized (list) {
                try {
                    for (EMGroupChangeListener eMGroupChangeListener : EMGroupManager.this.groupChangeListeners) {
                        eMGroupChangeListener.onSharedFileDeleted(group.groupId(), fileId);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onUpdateSpecificationFromGroup(EMAGroup group) {
            List<EMGroupChangeListener> list = EMGroupManager.this.groupChangeListeners;
            synchronized (list) {
                for (EMGroupChangeListener eMGroupChangeListener : EMGroupManager.this.groupChangeListeners) {
                    try {
                        if (null == group) continue;
                        eMGroupChangeListener.onSpecificationChanged(new EMGroup(group));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onStateChangedFromGroup(EMAGroup group, boolean isDisabled) {
            List<EMGroupChangeListener> list = EMGroupManager.this.groupChangeListeners;
            synchronized (list) {
                for (EMGroupChangeListener eMGroupChangeListener : EMGroupManager.this.groupChangeListeners) {
                    try {
                        eMGroupChangeListener.onStateChanged(new EMGroup(group), isDisabled);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
    };
    EMClient mClient;

    EMGroupManager(EMClient client, EMAGroupManager groupManager) {
        this.emaObject = groupManager;
        this.mClient = client;
        this.groupChangeListeners = Collections.synchronizedList(new ArrayList());
        this.emaObject.addListener(this.listenerImpl);
        EMClient.getInstance().chatManager();
    }

    public List<EMGroup> getAllGroups() {
        EMAError eMAError = new EMAError();
        List<EMAGroup> list = this.emaObject.allMyGroups(eMAError);
        ArrayList<EMGroup> arrayList = new ArrayList<EMGroup>();
        for (EMAGroup eMAGroup : list) {
            arrayList.add(new EMGroup(eMAGroup));
        }
        return Collections.unmodifiableList(arrayList);
    }

    public EMGroup getGroup(String groupId) {
        EMAError eMAError = new EMAError();
        List<EMAGroup> list = this.emaObject.allMyGroups(eMAError);
        for (EMAGroup eMAGroup : list) {
            if (!eMAGroup.groupId().equals(groupId)) continue;
            return new EMGroup(eMAGroup);
        }
        return null;
    }

    public EMGroup createGroup(String groupName, String desc, String[] allMembers, String reason, EMGroupOptions option) throws HyphenateException {
        int n = 0;
        switch (option.style) {
            case EMGroupStylePrivateOnlyOwnerInvite: {
                n = 0;
                break;
            }
            case EMGroupStylePrivateMemberCanInvite: {
                n = 1;
                break;
            }
            case EMGroupStylePublicJoinNeedApproval: {
                n = 2;
                break;
            }
            case EMGroupStylePublicOpenJoin: {
                n = 3;
            }
        }
        return this.createGroup(n, groupName, desc, allMembers, option.maxUsers, reason, option.inviteNeedConfirm, option.extField);
    }

    public void asyncCreateGroup(final String groupName, final String desc, final String[] allMembers, final String reason, final EMGroupOptions option, final EMValueCallBack<EMGroup> callback) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMGroup eMGroup = EMGroupManager.this.createGroup(groupName, desc, allMembers, reason, option);
                    callback.onSuccess(eMGroup);
                }
                catch (HyphenateException hyphenateException) {
                    callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    private EMGroup createGroup(int style, String groupName, String desc, String[] allMembers, int maxUsers, String reason, boolean inviteNeedConfirm, String extension) throws HyphenateException {
        EMAGroupSetting eMAGroupSetting = new EMAGroupSetting(style, maxUsers, inviteNeedConfirm, extension);
        ArrayList<String> arrayList = new ArrayList<String>();
        Collections.addAll(arrayList, allMembers);
        EMAError eMAError = new EMAError();
        EMAGroup eMAGroup = this.emaObject.createGroup(groupName, desc, reason, eMAGroupSetting, arrayList, inviteNeedConfirm, eMAError);
        this.handleError(eMAError);
        return new EMGroup(eMAGroup);
    }

    public synchronized void loadAllGroups() {
        this.emaObject.loadAllMyGroupsFromDB();
    }

    public void destroyGroup(String groupId) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.destroyGroup(groupId, eMAError);
        EMClient.getInstance().chatManager().caches.remove(groupId);
        this.handleError(eMAError);
    }

    public void asyncDestroyGroup(final String groupId, final EMCallBack callback) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMGroupManager.this.destroyGroup(groupId);
                    callback.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void addUsersToGroup(String groupId, String[] newmembers) throws HyphenateException {
        this.addUsersToGroup(groupId, newmembers, "welcome");
    }

    public void addUsersToGroup(String groupId, String[] newmembers, String welcomeMessage) throws HyphenateException {
        EMAError eMAError = new EMAError();
        ArrayList<String> arrayList = new ArrayList<String>();
        Collections.addAll(arrayList, newmembers);
        this.emaObject.addGroupMembers(groupId, arrayList, welcomeMessage, eMAError);
        this.handleError(eMAError);
    }

    public void asyncAddUsersToGroup(final String groupId, final String[] newmembers, final EMCallBack callback) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMGroupManager.this.addUsersToGroup(groupId, newmembers);
                    callback.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void removeUserFromGroup(String groupId, String username) throws HyphenateException {
        ArrayList<String> arrayList = new ArrayList<String>();
        EMAError eMAError = new EMAError();
        arrayList.add(username);
        this.emaObject.removeGroupMembers(groupId, arrayList, eMAError);
        this.handleError(eMAError);
        this.emaObject.fetchGroupSpecification(groupId, eMAError, true);
        this.handleError(eMAError);
    }

    public void asyncRemoveUserFromGroup(final String groupId, final String username, final EMCallBack callback) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMGroupManager.this.removeUserFromGroup(groupId, username);
                    callback.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void removeUsersFromGroup(String groupId, List<String> members) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.removeGroupMembers(groupId, members, eMAError);
        this.handleError(eMAError);
        this.emaObject.fetchGroupSpecification(groupId, eMAError, true);
        this.handleError(eMAError);
    }

    public void asyncRemoveUsersFromGroup(final String groupId, final List<String> members, final EMCallBack callback) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMGroupManager.this.removeUsersFromGroup(groupId, members);
                    callback.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void leaveGroup(String groupId) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.leaveGroup(groupId, eMAError);
        EMClient.getInstance().chatManager().caches.remove(groupId);
        this.handleError(eMAError);
    }

    public void asyncLeaveGroup(final String groupId, final EMCallBack callback) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMGroupManager.this.leaveGroup(groupId);
                    callback.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public EMGroup getGroupFromServer(String groupId) throws HyphenateException {
        if (groupId == null || groupId.isEmpty()) {
            throw new HyphenateException(600, "group id is null or empty");
        }
        EMAError eMAError = new EMAError();
        EMAGroup eMAGroup = this.emaObject.fetchGroupSpecification(groupId, eMAError, false);
        this.handleError(eMAError);
        return new EMGroup(eMAGroup);
    }

    public EMGroup getGroupFromServer(String groupId, boolean fetchMembers) throws HyphenateException {
        if (groupId == null || groupId.isEmpty()) {
            throw new HyphenateException(600, "group id is null or empty");
        }
        EMAError eMAError = new EMAError();
        EMAGroup eMAGroup = this.emaObject.fetchGroupSpecification(groupId, eMAError, fetchMembers);
        this.handleError(eMAError);
        return new EMGroup(eMAGroup);
    }

    public void asyncGetGroupFromServer(final String groupId, final EMValueCallBack<EMGroup> callback) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMGroup eMGroup = EMGroupManager.this.getGroupFromServer(groupId);
                    callback.onSuccess(eMGroup);
                }
                catch (HyphenateException hyphenateException) {
                    callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    synchronized List<EMGroup> getGroupsFromServer() throws HyphenateException {
        EMAError eMAError = new EMAError();
        List<EMAGroup> list = this.emaObject.fetchAllMyGroups(eMAError);
        this.handleError(eMAError);
        ArrayList<EMGroup> arrayList = new ArrayList<EMGroup>();
        for (EMAGroup eMAGroup : list) {
            arrayList.add(new EMGroup(eMAGroup));
        }
        return arrayList;
    }

    synchronized List<EMGroup> getGroupsFromServer(int pageIndex, int pageSize) throws HyphenateException {
        EMAError eMAError = new EMAError();
        List<EMAGroup> list = this.emaObject.fetchAllMyGroupsWithPage(pageIndex, pageSize, eMAError);
        this.handleError(eMAError);
        ArrayList<EMGroup> arrayList = new ArrayList<EMGroup>();
        for (EMAGroup eMAGroup : list) {
            arrayList.add(new EMGroup(eMAGroup));
        }
        return arrayList;
    }

    void asyncGetGroupsFromServer(final EMValueCallBack<List<EMGroup>> callback) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    List<EMGroup> list = EMGroupManager.this.getGroupsFromServer();
                    callback.onSuccess(list);
                }
                catch (HyphenateException hyphenateException) {
                    callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public synchronized List<EMGroup> getJoinedGroupsFromServer() throws HyphenateException {
        return this.getGroupsFromServer();
    }

    public synchronized List<EMGroup> getJoinedGroupsFromServer(int pageIndex, int pageSize) throws HyphenateException {
        return this.getGroupsFromServer(pageIndex, pageSize);
    }

    public void asyncGetJoinedGroupsFromServer(final EMValueCallBack<List<EMGroup>> callback) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    List<EMGroup> list = EMGroupManager.this.getJoinedGroupsFromServer();
                    callback.onSuccess(list);
                }
                catch (HyphenateException hyphenateException) {
                    callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void asyncGetJoinedGroupsFromServer(final int pageIndex, final int pageSize, final EMValueCallBack<List<EMGroup>> callback) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    List<EMGroup> list = EMGroupManager.this.getJoinedGroupsFromServer(pageIndex, pageSize);
                    callback.onSuccess(list);
                }
                catch (HyphenateException hyphenateException) {
                    callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public EMCursorResult<EMGroupInfo> getPublicGroupsFromServer(int pageSize, String cursor) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMCursorResult<EMGroupInfo> eMCursorResult = this.emaObject.fetchPublicGroupsWithCursor(cursor, pageSize, eMAError);
        this.handleError(eMAError);
        return eMCursorResult;
    }

    public void asyncGetPublicGroupsFromServer(final int pageSize, final String cursor, final EMValueCallBack<EMCursorResult<EMGroupInfo>> callback) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMCursorResult<EMGroupInfo> eMCursorResult = EMGroupManager.this.getPublicGroupsFromServer(pageSize, cursor);
                    callback.onSuccess(eMCursorResult);
                }
                catch (HyphenateException hyphenateException) {
                    callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void joinGroup(String groupId) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMAGroup eMAGroup = this.emaObject.fetchGroupSpecification(groupId, eMAError, false);
        this.handleError(eMAError);
        if (eMAGroup.groupSetting() == null) {
            throw new HyphenateException();
        }
        if (eMAGroup.groupSetting().style() == 3) {
            this.emaObject.joinPublicGroup(groupId, eMAError);
            this.handleError(eMAError);
            return;
        }
        if (eMAGroup.groupSetting().style() == 2) {
            this.emaObject.applyJoinPublicGroup(groupId, this.mClient.getCurrentUser(), "hello", eMAError);
            this.handleError(eMAError);
            return;
        }
    }

    public void asyncJoinGroup(final String groupId, final EMCallBack callback) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMGroupManager.this.joinGroup(groupId);
                    callback.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void changeGroupName(String groupId, String changedGroupName) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.changeGroupSubject(groupId, changedGroupName, eMAError);
        this.handleError(eMAError);
    }

    public void asyncChangeGroupName(final String groupId, final String changedGroupName, final EMCallBack callback) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMGroupManager.this.changeGroupName(groupId, changedGroupName);
                    callback.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void changeGroupDescription(String groupId, String changedDescription) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.changeGroupDescription(groupId, changedDescription, eMAError);
        this.handleError(eMAError);
    }

    public void asyncChangeGroupDescription(final String groupId, final String changedDescription, final EMCallBack callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMGroupManager.this.changeGroupDescription(groupId, changedDescription);
                    callBack.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public EMGroup acceptInvitation(String groupId, String inviter) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMAGroup eMAGroup = this.emaObject.acceptInvitationFromGroup(groupId, inviter == null ? "" : inviter, eMAError);
        this.handleError(eMAError);
        return new EMGroup(eMAGroup);
    }

    public void asyncAcceptInvitation(final String groupId, final String inviter, final EMValueCallBack<EMGroup> callback) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMGroup eMGroup = EMGroupManager.this.acceptInvitation(groupId, inviter);
                    callback.onSuccess(eMGroup);
                }
                catch (HyphenateException hyphenateException) {
                    callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void declineInvitation(String groupId, String inviter, String reason) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.declineInvitationFromGroup(groupId, inviter == null ? "" : inviter, reason == null ? "" : reason, eMAError);
        this.handleError(eMAError);
    }

    public void asyncDeclineInvitation(final String groupId, final String inviter, final String reason, final EMCallBack callback) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMGroupManager.this.declineInvitation(groupId, inviter, reason);
                    callback.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void acceptApplication(String username, String groupId) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.acceptJoinGroupApplication(groupId, username, eMAError);
        this.handleError(eMAError);
    }

    public void asyncAcceptApplication(final String username, final String groupId, final EMCallBack callback) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMGroupManager.this.acceptApplication(username, groupId);
                    callback.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void declineApplication(String username, String groupId, String reason) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.declineJoinGroupApplication(groupId, username, reason, eMAError);
        this.handleError(eMAError);
    }

    public void asyncDeclineApplication(final String username, final String groupId, final String reason, final EMCallBack callback) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMGroupManager.this.declineApplication(username, groupId, reason);
                    callback.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void inviteUser(String groupId, String[] beInvitedUsernames, String reason) throws HyphenateException {
        EMAError eMAError = new EMAError();
        ArrayList<String> arrayList = new ArrayList<String>();
        Collections.addAll(arrayList, beInvitedUsernames);
        this.emaObject.addGroupMembers(groupId, arrayList, reason, eMAError);
        this.handleError(eMAError);
    }

    public void asyncInviteUser(final String groupId, final String[] beInvitedUsernames, final String reason, final EMCallBack callback) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMGroupManager.this.inviteUser(groupId, beInvitedUsernames, reason);
                    callback.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void applyJoinToGroup(String groupId, String reason) throws HyphenateException {
        String string = this.mClient.getCurrentUser();
        EMAError eMAError = new EMAError();
        this.emaObject.applyJoinPublicGroup(groupId, string, reason, eMAError);
        this.handleError(eMAError);
    }

    public void asyncApplyJoinToGroup(final String groupId, final String reason, final EMCallBack callback) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMGroupManager.this.applyJoinToGroup(groupId, reason);
                    callback.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void blockGroupMessage(String groupId) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.blockGroupMessage(groupId, eMAError);
        this.handleError(eMAError);
    }

    public void asyncBlockGroupMessage(final String groupId, final EMCallBack callback) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMGroupManager.this.blockGroupMessage(groupId);
                    callback.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void unblockGroupMessage(String groupId) throws HyphenateException {
        EMLog.d(TAG, "try to unblock group msg:" + groupId);
        EMAError eMAError = new EMAError();
        this.emaObject.unblockGroupMessage(groupId, eMAError);
        this.handleError(eMAError);
    }

    public void asyncUnblockGroupMessage(final String groupId, final EMCallBack callback) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMGroupManager.this.unblockGroupMessage(groupId);
                    callback.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void blockUser(String groupId, String username) throws HyphenateException {
        EMLog.d(TAG, "block user for groupid:" + groupId + " username:" + username);
        EMAError eMAError = new EMAError();
        String string = "";
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(username);
        this.emaObject.blockGroupMembers(groupId, arrayList, eMAError, string);
        this.handleError(eMAError);
    }

    public void asyncBlockUser(final String groupId, final String username, final EMCallBack callback) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMGroupManager.this.blockUser(groupId, username);
                    callback.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void blockUsers(String groupId, List<String> members) throws HyphenateException {
        EMLog.d(TAG, "block user for groupid:" + groupId + " members:" + members == null ? "" : members.toString());
        EMAError eMAError = new EMAError();
        String string = "";
        this.emaObject.blockGroupMembers(groupId, members, eMAError, string);
        this.handleError(eMAError);
    }

    public void asyncBlockUsers(final String groupId, final List<String> members, final EMCallBack callback) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMGroupManager.this.blockUsers(groupId, members);
                    callback.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void unblockUser(String groupId, String username) throws HyphenateException {
        EMLog.d(TAG, "unblock user groupid:" + groupId + " username:" + username);
        EMAError eMAError = new EMAError();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(username);
        this.emaObject.unblockGroupMembers(groupId, arrayList, eMAError);
        this.handleError(eMAError);
    }

    public void asyncUnblockUser(final String groupId, final String username, final EMCallBack callback) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMGroupManager.this.unblockUser(groupId, username);
                    callback.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void unblockUsers(String groupId, List<String> members) throws HyphenateException {
        EMLog.d(TAG, "unblock user groupid:" + groupId + " members:" + members == null ? "" : members.toString());
        EMAError eMAError = new EMAError();
        this.emaObject.unblockGroupMembers(groupId, members, eMAError);
        this.handleError(eMAError);
    }

    public void asyncUnblockUsers(final String groupId, final List<String> members, final EMCallBack callback) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMGroupManager.this.unblockUsers(groupId, members);
                    callback.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public List<String> getBlockedUsers(String groupId) throws HyphenateException {
        return this.getBlockedUsers(groupId, 0, 200);
    }

    public List<String> getBlockedUsers(String groupId, int pageIndex, int pageSize) throws HyphenateException {
        EMLog.d(TAG, "get blocked users of the group: " + groupId);
        EMAError eMAError = new EMAError();
        List<String> list = this.emaObject.fetchGroupBlackList(groupId, pageIndex, pageSize, eMAError);
        this.handleError(eMAError);
        return list;
    }

    public void asyncGetBlockedUsers(String groupId, EMValueCallBack<List<String>> callback) {
        this.asyncGetBlockedUsers(groupId, 0, 200, callback);
    }

    public void asyncGetBlockedUsers(final String groupId, final int pageIndex, final int pageSize, final EMValueCallBack<List<String>> callback) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    List<String> list = EMGroupManager.this.getBlockedUsers(groupId, pageIndex, pageSize);
                    callback.onSuccess(list);
                }
                catch (HyphenateException hyphenateException) {
                    callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void addGroupChangeListener(EMGroupChangeListener listener) {
        EMLog.d(TAG, "add group change listener:" + listener.getClass().getName());
        if (!this.groupChangeListeners.contains(listener)) {
            this.groupChangeListeners.add(listener);
        }
    }

    public void removeGroupChangeListener(EMGroupChangeListener listener) {
        if (listener != null) {
            EMLog.d(TAG, "remove group change listener:" + listener.getClass().getName());
            this.groupChangeListeners.remove(listener);
        }
    }

    public EMCursorResult<String> fetchGroupMembers(String groupId, String cursor, int pageSize) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMCursorResult<String> eMCursorResult = this.emaObject.fetchGroupMembers(groupId, cursor, pageSize, eMAError);
        this.handleError(eMAError);
        return eMCursorResult;
    }

    public void asyncFetchGroupMembers(final String groupId, final String cursor, final int pageSize, final EMValueCallBack<EMCursorResult<String>> callback) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMCursorResult<String> eMCursorResult = EMGroupManager.this.fetchGroupMembers(groupId, cursor, pageSize);
                    callback.onSuccess(eMCursorResult);
                }
                catch (HyphenateException hyphenateException) {
                    callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public EMGroup changeOwner(String groupId, String newOwner) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMAGroup eMAGroup = this.emaObject.transferGroupOwner(groupId, newOwner, eMAError);
        this.handleError(eMAError);
        return new EMGroup(eMAGroup);
    }

    public void asyncChangeOwner(final String groupId, final String newOwner, final EMValueCallBack<EMGroup> callback) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMGroup eMGroup = EMGroupManager.this.changeOwner(groupId, newOwner);
                    callback.onSuccess(eMGroup);
                }
                catch (HyphenateException hyphenateException) {
                    callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public EMGroup addGroupAdmin(String groupId, String admin) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMAGroup eMAGroup = this.emaObject.addGroupAdmin(groupId, admin, eMAError);
        this.handleError(eMAError);
        return new EMGroup(eMAGroup);
    }

    public void asyncAddGroupAdmin(final String groupId, final String admin, final EMValueCallBack<EMGroup> callback) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callback.onSuccess(EMGroupManager.this.addGroupAdmin(groupId, admin));
                }
                catch (HyphenateException hyphenateException) {
                    callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public EMGroup removeGroupAdmin(String groupId, String admin) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMAGroup eMAGroup = this.emaObject.removeGroupAdmin(groupId, admin, eMAError);
        this.handleError(eMAError);
        return new EMGroup(eMAGroup);
    }

    public void asyncRemoveGroupAdmin(final String groupId, final String admin, final EMValueCallBack<EMGroup> callback) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callback.onSuccess(EMGroupManager.this.removeGroupAdmin(groupId, admin));
                }
                catch (HyphenateException hyphenateException) {
                    callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public EMGroup muteGroupMembers(String groupId, List<String> muteMembers, long duration) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMAGroup eMAGroup = this.emaObject.muteGroupMembers(groupId, muteMembers, duration, eMAError);
        this.handleError(eMAError);
        return new EMGroup(eMAGroup);
    }

    public void aysncMuteGroupMembers(final String groupId, final List<String> muteMembers, final long duration, final EMValueCallBack<EMGroup> callback) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callback.onSuccess(EMGroupManager.this.muteGroupMembers(groupId, muteMembers, duration));
                }
                catch (HyphenateException hyphenateException) {
                    callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public EMGroup unMuteGroupMembers(String groupId, List<String> members) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMAGroup eMAGroup = this.emaObject.unMuteGroupMembers(groupId, members, eMAError);
        this.handleError(eMAError);
        return new EMGroup(eMAGroup);
    }

    public void asyncUnMuteGroupMembers(final String groupId, final List<String> members, final EMValueCallBack<EMGroup> callback) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callback.onSuccess(EMGroupManager.this.unMuteGroupMembers(groupId, members));
                }
                catch (HyphenateException hyphenateException) {
                    callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public Map<String, Long> fetchGroupMuteList(String groupId, int pageNum, int pageSize) throws HyphenateException {
        EMAError eMAError = new EMAError();
        Map<String, Long> map = this.emaObject.fetchGroupMutes(groupId, pageNum, pageSize, eMAError);
        this.handleError(eMAError);
        return map;
    }

    public void asyncFetchGroupMuteList(final String groupId, final int pageNum, final int pageSize, final EMValueCallBack<Map<String, Long>> callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callBack.onSuccess(EMGroupManager.this.fetchGroupMuteList(groupId, pageNum, pageSize));
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public List<String> fetchGroupBlackList(String groupId, int pageNum, int pageSize) throws HyphenateException {
        EMAError eMAError = new EMAError();
        List<String> list = this.emaObject.fetchGroupBlackList(groupId, pageNum, pageSize, eMAError);
        this.handleError(eMAError);
        return list;
    }

    public void asyncFetchGroupBlackList(final String groupId, final int pageNum, final int pageSize, final EMValueCallBack<List<String>> callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callBack.onSuccess(EMGroupManager.this.fetchGroupBlackList(groupId, pageNum, pageSize));
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void addToGroupWhiteList(final String groupId, final List<String> members, final EMCallBack callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    EMGroupManager.this.emaObject.addToWhiteList(groupId, members, eMAError);
                    EMGroupManager.this.handleError(eMAError);
                    callBack.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void removeFromGroupWhiteList(final String groupId, final List<String> members, final EMCallBack callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    EMGroupManager.this.emaObject.removeFromWhiteList(groupId, members, eMAError);
                    EMGroupManager.this.handleError(eMAError);
                    callBack.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void checkIfInGroupWhiteList(final String groupId, final EMValueCallBack<Boolean> callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    Boolean bl = EMGroupManager.this.emaObject.checkIfInWhiteList(groupId, eMAError);
                    EMGroupManager.this.handleError(eMAError);
                    callBack.onSuccess(bl);
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void fetchGroupWhiteList(final String groupId, final EMValueCallBack<List<String>> callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    List<String> list = EMGroupManager.this.emaObject.fetchGroupWhiteList(groupId, eMAError);
                    EMGroupManager.this.handleError(eMAError);
                    callBack.onSuccess(list);
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void muteAllMembers(final String groupId, final EMValueCallBack<EMGroup> callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    EMAGroup eMAGroup = EMGroupManager.this.emaObject.muteAllMembers(groupId, eMAError);
                    EMGroupManager.this.handleError(eMAError);
                    callBack.onSuccess(new EMGroup(eMAGroup));
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void unmuteAllMembers(final String groupId, final EMValueCallBack<EMGroup> callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    EMAGroup eMAGroup = EMGroupManager.this.emaObject.unmuteAllMembers(groupId, eMAError);
                    EMGroupManager.this.handleError(eMAError);
                    callBack.onSuccess(new EMGroup(eMAGroup));
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void updateGroupAnnouncement(String groupId, String announcement) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.updateGroupAnnouncement(groupId, announcement, eMAError);
        this.handleError(eMAError);
    }

    public void asyncUpdateGroupAnnouncement(final String groupId, final String announcement, final EMCallBack callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMGroupManager.this.updateGroupAnnouncement(groupId, announcement);
                    callBack.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public String fetchGroupAnnouncement(String groupId) throws HyphenateException {
        EMAError eMAError = new EMAError();
        String string = this.emaObject.fetchGroupAnnouncement(groupId, eMAError);
        this.handleError(eMAError);
        return string;
    }

    public void asyncFetchGroupAnnouncement(final String groupId, final EMValueCallBack<String> callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callBack.onSuccess(EMGroupManager.this.fetchGroupAnnouncement(groupId));
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public EMMucSharedFile uploadGroupSharedFile(String groupId, String filePath, EMCallBack callBack) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMACallback eMACallback = new EMACallback(callBack);
        EMAMucShareFile eMAMucShareFile = this.emaObject.uploadGroupShareFile(groupId, filePath, eMACallback, eMAError);
        this.handleError(eMAError);
        callBack.onSuccess();
        return new EMMucSharedFile(eMAMucShareFile);
    }

    public void asyncUploadGroupSharedFile(final String groupId, final String filePath, final EMCallBack callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMMucSharedFile eMMucSharedFile = EMGroupManager.this.uploadGroupSharedFile(groupId, filePath, callBack);
                    callBack.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public List<EMMucSharedFile> fetchGroupSharedFileList(String groupId, int pageNum, int pageSize) throws HyphenateException {
        EMAError eMAError = new EMAError();
        List<EMAMucShareFile> list = this.emaObject.fetchGroupShareFiles(groupId, pageNum, pageSize, eMAError);
        this.handleError(eMAError);
        ArrayList<EMMucSharedFile> arrayList = new ArrayList<EMMucSharedFile>();
        for (EMAMucShareFile eMAMucShareFile : list) {
            arrayList.add(new EMMucSharedFile(eMAMucShareFile));
        }
        return arrayList;
    }

    public void asyncFetchGroupSharedFileList(final String groupId, final int pageNum, final int pageSize, final EMValueCallBack<List<EMMucSharedFile>> callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    callBack.onSuccess(EMGroupManager.this.fetchGroupSharedFileList(groupId, pageNum, pageSize));
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void deleteGroupSharedFile(String groupId, String fileId) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.deleteGroupShareFile(groupId, fileId, eMAError);
        this.handleError(eMAError);
    }

    public void asyncDeleteGroupSharedFile(final String groupId, final String fileId, final EMCallBack callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMGroupManager.this.deleteGroupSharedFile(groupId, fileId);
                    callBack.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void downloadGroupSharedFile(String groupId, String fileId, String savePath, EMCallBack callBack) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMACallback eMACallback = new EMACallback(callBack);
        this.emaObject.downloadGroupShareFile(groupId, fileId, savePath, eMACallback, eMAError);
        this.handleError(eMAError);
    }

    public void asyncDownloadGroupSharedFile(final String groupId, final String fileId, final String savePath, final EMCallBack callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMGroupManager.this.downloadGroupSharedFile(groupId, fileId, savePath, callBack);
                    callBack.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public EMGroup updateGroupExtension(String groupId, String extension) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMAGroup eMAGroup = this.emaObject.updateGroupExtension(groupId, extension, eMAError);
        this.handleError(eMAError);
        return new EMGroup(eMAGroup);
    }

    void onLogout() {
    }

    private void handleError(EMAError error) throws HyphenateException {
        if (error.errCode() != 0) {
            throw new HyphenateException(error);
        }
    }

    public static enum EMGroupStyle {
        EMGroupStylePrivateOnlyOwnerInvite,
        EMGroupStylePrivateMemberCanInvite,
        EMGroupStylePublicJoinNeedApproval,
        EMGroupStylePublicOpenJoin;

    }
}

