/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.hyphenate.chat.EMFileMessageBody;
import com.hyphenate.chat.adapter.message.EMAFileMessageBody;
import com.hyphenate.chat.adapter.message.EMAImageMessageBody;
import com.hyphenate.util.EMFileHelper;
import java.io.File;

public class EMImageMessageBody
extends EMFileMessageBody
implements Parcelable {
    private static final String TAG = EMImageMessageBody.class.getSimpleName();
    private boolean sendOriginalImage = false;
    public static final Parcelable.Creator<EMImageMessageBody> CREATOR = new Parcelable.Creator<EMImageMessageBody>(){

        public EMImageMessageBody createFromParcel(Parcel in) {
            return new EMImageMessageBody(in);
        }

        public EMImageMessageBody[] newArray(int size) {
            return new EMImageMessageBody[size];
        }
    };

    public EMImageMessageBody(File imageFile) {
        super(Uri.fromFile((File)imageFile), 1);
    }

    public EMImageMessageBody(Uri imageUri) {
        super(imageUri, 1);
        this.setFileName(EMFileHelper.getInstance().getFilename(imageUri));
    }

    public EMImageMessageBody(File imageFile, File thumbnailFile) {
        super(Uri.fromFile((File)imageFile), 1);
        ((EMAImageMessageBody)this.emaObject).setThumbnailLocalPath(thumbnailFile == null ? "" : Uri.fromFile((File)thumbnailFile).toString());
    }

    public EMImageMessageBody(Uri imageLocalPath, Uri thumbnailPath) {
        super(imageLocalPath, 1);
        ((EMAImageMessageBody)this.emaObject).setThumbnailLocalPath(thumbnailPath != null ? thumbnailPath.toString() : "");
        this.setFileName(EMFileHelper.getInstance().getFilename(imageLocalPath));
    }

    public EMImageMessageBody(EMAImageMessageBody body) {
        super(body);
    }

    EMImageMessageBody(String fileName, String remoteUrl, String thumbnailUrl) {
        super((Uri)null, 1);
        this.emaObject = new EMAImageMessageBody((Uri)null, (Uri)null);
        ((EMAImageMessageBody)this.emaObject).setDisplayName(fileName);
        ((EMAImageMessageBody)this.emaObject).setRemotePath(remoteUrl);
        ((EMAImageMessageBody)this.emaObject).setThumbnailRemotePath(thumbnailUrl);
    }

    public String getThumbnailUrl() {
        return ((EMAImageMessageBody)this.emaObject).thumbnailRemotePath();
    }

    public void setThumbnailUrl(String thumbnailUrl) {
        ((EMAImageMessageBody)this.emaObject).setThumbnailRemotePath(thumbnailUrl);
    }

    public String toString() {
        return "image: " + ((EMAImageMessageBody)this.emaObject).displayName() + ", localurl: " + ((EMAImageMessageBody)this.emaObject).getLocalUrl() + ", remoteurl: " + ((EMAImageMessageBody)this.emaObject).getRemoteUrl() + ", thumbnail: " + ((EMAImageMessageBody)this.emaObject).thumbnailRemotePath();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(((EMAImageMessageBody)this.emaObject).displayName());
        dest.writeString(((EMAImageMessageBody)this.emaObject).getLocalUrl());
        dest.writeString(((EMAImageMessageBody)this.emaObject).getRemoteUrl());
        dest.writeString(((EMAImageMessageBody)this.emaObject).thumbnailRemotePath());
        dest.writeInt(((EMAImageMessageBody)this.emaObject).width());
        dest.writeInt(((EMAImageMessageBody)this.emaObject).height());
    }

    private EMImageMessageBody(Parcel in) {
        super((Uri)null, 1);
        ((EMAImageMessageBody)this.emaObject).setDisplayName(in.readString());
        ((EMAImageMessageBody)this.emaObject).setLocalPath(in.readString());
        ((EMAImageMessageBody)this.emaObject).setRemotePath(in.readString());
        ((EMAImageMessageBody)this.emaObject).setThumbnailRemotePath(in.readString());
        int n = in.readInt();
        int n2 = in.readInt();
        ((EMAImageMessageBody)this.emaObject).setSize(n, n2);
    }

    public void setThumbnailSecret(String secret) {
        ((EMAImageMessageBody)this.emaObject).setThumbnailSecretKey(secret);
    }

    public String getThumbnailSecret() {
        return ((EMAImageMessageBody)this.emaObject).thumbnailSecretKey();
    }

    public void setSendOriginalImage(boolean sendOriginalImage) {
        this.sendOriginalImage = sendOriginalImage;
    }

    public boolean isSendOriginalImage() {
        return this.sendOriginalImage;
    }

    public int getWidth() {
        return ((EMAImageMessageBody)this.emaObject).width();
    }

    public int getHeight() {
        return ((EMAImageMessageBody)this.emaObject).height();
    }

    @Override
    public String getFileName() {
        return ((EMAImageMessageBody)this.emaObject).displayName();
    }

    void setSize(int width, int height) {
        ((EMAImageMessageBody)this.emaObject).setSize(width, height);
    }

    public long getFileSize() {
        return ((EMAImageMessageBody)this.emaObject).fileLength();
    }

    public String thumbnailLocalPath() {
        return EMFileHelper.getInstance().formatOutLocalUrl(((EMAImageMessageBody)this.emaObject).thumbnailLocalPath());
    }

    public Uri thumbnailLocalUri() {
        return EMFileHelper.getInstance().formatOutUri(((EMAImageMessageBody)this.emaObject).thumbnailLocalPath());
    }

    public void setThumbnailLocalPath(String localPath) {
        ((EMAImageMessageBody)this.emaObject).setThumbnailLocalPath(EMFileHelper.getInstance().formatInUriToString(localPath));
    }

    public void setThumbnailLocalPath(Uri localPath) {
        ((EMAImageMessageBody)this.emaObject).setThumbnailLocalPath(EMFileHelper.getInstance().formatInUriToString(localPath));
    }

    public void setThumbnailSize(int width, int height) {
        ((EMAImageMessageBody)this.emaObject).setThumbnailSize(width, height);
    }

    public EMFileMessageBody.EMDownloadStatus thumbnailDownloadStatus() {
        EMAFileMessageBody.EMADownloadStatus eMADownloadStatus = ((EMAImageMessageBody)this.emaObject).thumbnailDownloadStatus();
        switch (eMADownloadStatus) {
            case DOWNLOADING: {
                return EMFileMessageBody.EMDownloadStatus.DOWNLOADING;
            }
            case SUCCESSED: {
                return EMFileMessageBody.EMDownloadStatus.SUCCESSED;
            }
            case FAILED: {
                return EMFileMessageBody.EMDownloadStatus.FAILED;
            }
            case PENDING: {
                return EMFileMessageBody.EMDownloadStatus.PENDING;
            }
        }
        return EMFileMessageBody.EMDownloadStatus.SUCCESSED;
    }

    void setThumbnailDownloadStatus(EMFileMessageBody.EMDownloadStatus status) {
        ((EMAImageMessageBody)this.emaObject).setThumbnailDownloadStatus(EMAFileMessageBody.EMADownloadStatus.valueOf(status.name()));
    }
}

