/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.text.TextUtils;
import android.util.Pair;
import com.hyphenate.EMCallBack;
import com.hyphenate.EMValueCallBack;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMConversation;
import com.hyphenate.chat.EMPushConfigs;
import com.hyphenate.chat.EMSilentModeParam;
import com.hyphenate.chat.EMSilentModeResult;
import com.hyphenate.chat.adapter.EMAError;
import com.hyphenate.chat.adapter.EMAPushConfigs;
import com.hyphenate.chat.adapter.EMAPushManager;
import com.hyphenate.chat.adapter.EMASilentModeItem;
import com.hyphenate.chat.adapter.EMASilentModeParam;
import com.hyphenate.chat.core.a;
import com.hyphenate.cloud.EMHttpClient;
import com.hyphenate.exceptions.HyphenateException;
import com.hyphenate.util.DeviceUuidFactory;
import com.hyphenate.util.EMLog;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class EMPushManager {
    private static final String TAG = EMPushManager.class.getSimpleName();
    EMClient mClient;
    EMAPushManager emaObject;

    EMPushManager(EMClient client, EMAPushManager pushManager) {
        this.emaObject = pushManager;
        this.mClient = client;
    }

    @Deprecated
    public void enableOfflinePush() throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.enableOfflineNotification(eMAError);
        this.handleError(eMAError);
    }

    @Deprecated
    public void disableOfflinePush(int start, int end) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.disableOfflineNotification(start, end, eMAError);
        this.handleError(eMAError);
    }

    public EMPushConfigs getPushConfigs() {
        EMAPushConfigs eMAPushConfigs = this.emaObject.getPushConfigs();
        if (eMAPushConfigs == null) {
            return null;
        }
        return new EMPushConfigs(eMAPushConfigs);
    }

    public EMPushConfigs getPushConfigsFromServer() throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMAPushConfigs eMAPushConfigs = this.emaObject.getPushConfigsFromServer(eMAError);
        this.handleError(eMAError);
        return new EMPushConfigs(eMAPushConfigs);
    }

    @Deprecated
    public void updatePushServiceForGroup(List<String> groupIds, boolean noPush) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.updatePushServiceForGroup(groupIds, noPush, eMAError);
        this.handleError(eMAError);
    }

    @Deprecated
    public void updatePushServiceForUsers(List<String> userIds, boolean noPush) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.updatePushServiceForUsers(userIds, noPush, eMAError);
        this.handleError(eMAError);
    }

    @Deprecated
    public List<String> getNoPushGroups() {
        return this.emaObject.getNoPushGroups();
    }

    @Deprecated
    public List<String> getNoPushUsers() {
        return this.emaObject.getNoPushUsers();
    }

    public boolean updatePushNickname(String nickname) throws IllegalArgumentException, HyphenateException {
        if (TextUtils.isEmpty((CharSequence)nickname)) {
            throw new IllegalArgumentException("nick name is null or empty");
        }
        String string = EMClient.getInstance().getCurrentUser();
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("currentUser is null or empty");
        }
        String string2 = EMClient.getInstance().getAccessToken();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("token is null or empty");
        }
        EMAError eMAError = new EMAError();
        this.emaObject.updatePushNickname(nickname, eMAError);
        this.handleError(eMAError);
        return true;
    }

    public void asyncUpdatePushNickname(final String nickname, final EMCallBack callback) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMPushManager.this.updatePushNickname(nickname);
                    callback.onSuccess();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    callback.onError(205, illegalArgumentException.getMessage());
                }
                catch (HyphenateException hyphenateException) {
                    callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void updatePushDisplayStyle(DisplayStyle style) throws IllegalArgumentException, HyphenateException {
        String string = EMClient.getInstance().getCurrentUser();
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("currentUser is null or empty");
        }
        String string2 = EMClient.getInstance().getAccessToken();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("token is null or empty");
        }
        EMAError eMAError = new EMAError();
        this.emaObject.updatePushDisplayStyle(style.ordinal(), eMAError);
        this.handleError(eMAError);
    }

    public void asyncUpdatePushDisplayStyle(final DisplayStyle style, final EMCallBack callback) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMPushManager.this.updatePushDisplayStyle(style);
                    callback.onSuccess();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    callback.onError(205, illegalArgumentException.getMessage());
                }
                catch (HyphenateException hyphenateException) {
                    callback.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    private void reportPushAction(String parameters) throws IllegalArgumentException, HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.reportPushAction(parameters, eMAError);
        this.handleError(eMAError);
    }

    private void handleError(EMAError error) throws HyphenateException {
        if (error.errCode() != 0) {
            throw new HyphenateException(error);
        }
    }

    public void setSilentModeForConversation(final String conversationId, final EMConversation.EMConversationType type, final EMSilentModeParam param, final EMValueCallBack<EMSilentModeResult> callBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    EMASilentModeItem eMASilentModeItem = EMPushManager.this.emaObject.setSilentModeForConversation(conversationId, type.ordinal(), (EMASilentModeParam)param.emaObject, eMAError);
                    EMPushManager.this.handleError(eMAError);
                    callBack.onSuccess(new EMSilentModeResult(eMASilentModeItem));
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void clearRemindTypeForConversation(final String conversationId, final EMConversation.EMConversationType type, final EMCallBack callBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    EMPushManager.this.emaObject.clearRemindTypeForConversation(conversationId, type.ordinal(), eMAError);
                    EMPushManager.this.handleError(eMAError);
                    callBack.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void getSilentModeForConversation(final String conversationId, final EMConversation.EMConversationType type, final EMValueCallBack<EMSilentModeResult> callBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    EMASilentModeItem eMASilentModeItem = EMPushManager.this.emaObject.getSilentModeForConversation(conversationId, type.ordinal(), eMAError);
                    EMPushManager.this.handleError(eMAError);
                    callBack.onSuccess(new EMSilentModeResult(eMASilentModeItem));
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void setSilentModeForAll(final EMSilentModeParam param, final EMValueCallBack<EMSilentModeResult> callBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    EMASilentModeItem eMASilentModeItem = EMPushManager.this.emaObject.setSilentModeForAll((EMASilentModeParam)param.emaObject, eMAError);
                    EMPushManager.this.handleError(eMAError);
                    callBack.onSuccess(new EMSilentModeResult(eMASilentModeItem));
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void getSilentModeForAll(final EMValueCallBack<EMSilentModeResult> callBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    EMASilentModeItem eMASilentModeItem = EMPushManager.this.emaObject.getSilentModeForAll(eMAError);
                    EMPushManager.this.handleError(eMAError);
                    callBack.onSuccess(new EMSilentModeResult(eMASilentModeItem));
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void getSilentModeForConversations(final List<EMConversation> conversationList, final EMValueCallBack<Map<String, EMSilentModeResult>> callBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Object object2;
                    StringBuilder stringBuilder = new StringBuilder();
                    StringBuilder stringBuilder2 = new StringBuilder();
                    for (Object object2 : conversationList) {
                        if (((EMConversation)object2).getType() == EMConversation.EMConversationType.Chat) {
                            if (!stringBuilder.toString().isEmpty()) {
                                stringBuilder.append(",");
                            }
                            stringBuilder.append(((EMConversation)object2).conversationId());
                            continue;
                        }
                        if (!stringBuilder2.toString().isEmpty()) {
                            stringBuilder2.append(",");
                        }
                        stringBuilder2.append(((EMConversation)object2).conversationId());
                    }
                    HashMap hashMap = new HashMap();
                    hashMap.put("user", stringBuilder.toString());
                    hashMap.put("group", stringBuilder2.toString());
                    object2 = new EMAError();
                    List<EMASilentModeItem> list = EMPushManager.this.emaObject.getSilentModeForConversations(hashMap, (EMAError)object2);
                    EMPushManager.this.handleError((EMAError)object2);
                    HashMap<String, EMSilentModeResult> hashMap2 = new HashMap<String, EMSilentModeResult>();
                    for (EMASilentModeItem eMASilentModeItem : list) {
                        hashMap2.put(eMASilentModeItem.getConversationId(), new EMSilentModeResult(eMASilentModeItem));
                    }
                    callBack.onSuccess(hashMap2);
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void setPreferredNotificationLanguage(final String languageCode, final EMCallBack callBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    EMPushManager.this.emaObject.setPushPerformLanguage(languageCode, eMAError);
                    EMPushManager.this.handleError(eMAError);
                    callBack.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void getPreferredNotificationLanguage(final EMValueCallBack<String> callBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    String string = EMPushManager.this.emaObject.getPushPerformLanguage(eMAError);
                    EMPushManager.this.handleError(eMAError);
                    callBack.onSuccess(string);
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public synchronized void bindDeviceToken(String notifierName, String deviceToken, EMCallBack callBack) {
        if (this.mClient == null || !this.mClient.isSdkInited()) {
            if (callBack != null) {
                callBack.onError(1, "SDK should init first!");
            }
            return;
        }
        this.mClient.execute(() -> {
            block3: {
                try {
                    this.bindDeviceToken(notifierName, deviceToken);
                    if (callBack != null) {
                        callBack.onSuccess();
                    }
                }
                catch (HyphenateException hyphenateException) {
                    if (callBack == null) break block3;
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    void unBindDeviceToken() throws HyphenateException {
        this.bindDeviceToken(a.a().r(), "");
    }

    synchronized void bindDeviceToken(String notifierName, String deviceToken) throws HyphenateException {
        if (this.mClient == null || !this.mClient.isSdkInited()) {
            throw new HyphenateException(1, "SDK should init first!");
        }
        if (!this.mClient.isLoggedInBefore()) {
            throw new HyphenateException(1, "You need to log in first!");
        }
        if (TextUtils.isEmpty((CharSequence)notifierName)) {
            throw new HyphenateException(110, "Notifier name should not be empty!");
        }
        a a2 = a.a();
        String string = a2.q();
        if (!TextUtils.isEmpty((CharSequence)string) && TextUtils.equals((CharSequence)string, (CharSequence)deviceToken)) {
            if (!EMClient.getInstance().getChatConfigPrivate().I()) {
                EMLog.e(TAG, TAG + " not first login, ignore token upload action.");
                return;
            }
            EMLog.d(TAG, "push token not change, but last login is not on this device, upload to server");
        }
        String string2 = EMClient.getInstance().getChatConfigPrivate().a(true, false) + "/users/" + EMClient.getInstance().getCurrentUser();
        DeviceUuidFactory deviceUuidFactory = new DeviceUuidFactory(EMClient.getInstance().getContext());
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("device_token", (Object)(TextUtils.isEmpty((CharSequence)notifierName) ? "" : deviceToken));
            jSONObject.put("notifier_name", (Object)notifierName);
            jSONObject.put("device_id", (Object)deviceUuidFactory.getDeviceUuid().toString());
        }
        catch (Exception exception) {
            EMLog.e(TAG, "uploadTokenInternal put json exception: " + exception.toString());
            throw new HyphenateException(1, "uploadTokenInternal put json exception: " + exception.getMessage());
        }
        int n = 2;
        int n2 = 1;
        String string3 = "";
        do {
            try {
                EMLog.e(TAG, "uploadTokenInternal, token=" + deviceToken + ", url=" + string2 + ", notifier name=" + notifierName);
                Pair<Integer, String> pair = EMHttpClient.getInstance().sendRequestWithToken(string2, jSONObject.toString(), EMHttpClient.PUT);
                n2 = (Integer)pair.first;
                string3 = (String)pair.second;
                if (n2 == 200) {
                    a.a().h(deviceToken);
                    a.a().i(notifierName);
                    EMLog.e(TAG, "uploadTokenInternal success.");
                    return;
                }
                EMLog.e(TAG, "uploadTokenInternal failed: " + string3);
                string2 = EMClient.getInstance().getChatConfigPrivate().a(true, true) + "/users/" + EMClient.getInstance().getCurrentUser();
            }
            catch (HyphenateException hyphenateException) {
                EMLog.e(TAG, "uploadTokenInternal failed: " + hyphenateException.getDescription());
                string2 = EMClient.getInstance().getChatConfigPrivate().a(true, true) + "/users/" + EMClient.getInstance().getCurrentUser();
            }
        } while (--n > 0);
        throw new HyphenateException(n2, string3);
    }

    public void setPushTemplate(final String templateName, final EMCallBack callBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    EMPushManager.this.emaObject.setPushTemplate(templateName, eMAError);
                    EMPushManager.this.handleError(eMAError);
                    callBack.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void getPushTemplate(final EMValueCallBack<String> callBack) {
        this.mClient.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMAError eMAError = new EMAError();
                    String string = EMPushManager.this.emaObject.getPushTemplate(eMAError);
                    EMPushManager.this.handleError(eMAError);
                    callBack.onSuccess(string);
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void reportPushAction(final JSONObject json, final EMPushAction action, final EMCallBack callBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    if (json != null) {
                        json.put("action", (Object)action.name);
                        EMPushManager.this.reportPushAction(json.toString());
                    }
                    callBack.onSuccess();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    callBack.onError(205, illegalArgumentException.getMessage());
                }
                catch (HyphenateException hyphenateException) {
                    callBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
            }
        });
    }

    public static enum EMPushRemindType {
        ALL,
        MENTION_ONLY,
        NONE;

    }

    public static enum EMPushAction {
        ARRIVE("arrive"),
        CLICK("click");

        private String name;

        private EMPushAction(String name) {
            this.name = name;
        }
    }

    public static enum DisplayStyle {
        SimpleBanner,
        MessageSummary;

    }
}

