/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import com.hyphenate.EMValueCallBack;
import com.hyphenate.chat.EMUserInfo;
import com.hyphenate.chat.adapter.EMAError;
import com.hyphenate.chat.adapter.EMAUserInfoManager;
import com.hyphenate.util.EMLog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONException;
import org.json.JSONObject;

public class EMUserInfoManager {
    static final String TAG = "EMUserInfoManager";
    EMAUserInfoManager emaObject;
    private ExecutorService executorService;

    protected EMUserInfoManager(EMAUserInfoManager manager) {
        this.emaObject = manager;
        this.executorService = Executors.newCachedThreadPool();
    }

    public void updateOwnInfo(final EMUserInfo userInfo, final EMValueCallBack<String> callBack) {
        EMLog.d(TAG, "start updateOwnInfo");
        if (userInfo == null) {
            EMLog.d(TAG, "fetchUserInfoByUserId userInfo is empty");
            callBack.onError(205, "userInfo is empty");
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                EMAError eMAError = new EMAError();
                JSONObject jSONObject = new JSONObject();
                try {
                    if (userInfo != null) {
                        jSONObject.putOpt(EMUserInfo.EMUserInfoType.NICKNAME.getDesc(), (Object)userInfo.getNickName());
                        jSONObject.putOpt(EMUserInfo.EMUserInfoType.AVATAR_URL.getDesc(), (Object)userInfo.getAvatarUrl());
                        jSONObject.putOpt(EMUserInfo.EMUserInfoType.EMAIL.getDesc(), (Object)userInfo.getEmail());
                        jSONObject.putOpt(EMUserInfo.EMUserInfoType.GENDER.getDesc(), (Object)userInfo.getGender());
                        jSONObject.putOpt(EMUserInfo.EMUserInfoType.BIRTH.getDesc(), (Object)userInfo.getBirth());
                        jSONObject.putOpt(EMUserInfo.EMUserInfoType.PHONE.getDesc(), (Object)userInfo.getPhoneNumber());
                        jSONObject.putOpt(EMUserInfo.EMUserInfoType.SIGN.getDesc(), (Object)userInfo.getSignature());
                        jSONObject.putOpt(EMUserInfo.EMUserInfoType.EXT.getDesc(), (Object)userInfo.getExt());
                    }
                    EMLog.d(EMUserInfoManager.TAG, "updateOwnInfo param: " + jSONObject.toString());
                    EMUserInfoManager.this.emaObject.updateOwnInfo(jSONObject.toString(), eMAError);
                    if (callBack == null) {
                        return;
                    }
                    if (eMAError.errCode() == 0) {
                        EMLog.d(EMUserInfoManager.TAG, "updateOwnInfo success");
                        callBack.onSuccess(eMAError.toString());
                    } else {
                        EMLog.e(EMUserInfoManager.TAG, "updateOwnInfo failed error:" + eMAError.errCode() + "  errorMessage:" + eMAError.errMsg());
                        callBack.onError(eMAError.errCode(), eMAError.errMsg());
                    }
                }
                catch (Exception exception) {
                    exception.getStackTrace();
                }
            }
        });
    }

    public void updateOwnInfoByAttribute(final EMUserInfo.EMUserInfoType attribute, final String value, final EMValueCallBack<String> callBack) {
        EMLog.d(TAG, "start updateOwnInfoByAttribute");
        if (attribute == null) {
            EMLog.d(TAG, "fetchUserInfoByUserId attribute is null");
            callBack.onError(205, "attribute is null");
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                EMAError eMAError = new EMAError();
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.putOpt(attribute.getDesc(), (Object)value);
                    EMLog.d(EMUserInfoManager.TAG, "updateOwnInfoByAttribute param: " + jSONObject.toString());
                    String string = EMUserInfoManager.this.emaObject.updateOwnInfo(jSONObject.toString(), eMAError);
                    EMLog.d(EMUserInfoManager.TAG, "updateOwnInfoByAttribute response: " + string);
                    if (callBack == null) {
                        return;
                    }
                    if (eMAError.errCode() == 0) {
                        EMLog.d(EMUserInfoManager.TAG, "updateOwnInfoByAttribute success");
                        callBack.onSuccess(string);
                    } else {
                        EMLog.e(EMUserInfoManager.TAG, "updateOwnInfoByAttribute failed error:" + eMAError.errCode() + "  errorMessage:" + eMAError.errMsg());
                        callBack.onError(eMAError.errCode(), eMAError.errMsg());
                    }
                }
                catch (Exception exception) {
                    exception.getStackTrace();
                }
            }
        });
    }

    public void fetchUserInfoByUserId(final String[] userIds, final EMValueCallBack<Map<String, EMUserInfo>> callBack) {
        EMLog.d(TAG, "start fetchUserInfoByUserId");
        if (userIds == null || userIds.length == 0) {
            EMLog.d(TAG, "fetchUserInfoByUserId userIds is empty");
            callBack.onError(205, "userIds is empty");
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                EMAError eMAError = new EMAError();
                ArrayList<String> arrayList = new ArrayList<String>();
                Collections.addAll(arrayList, userIds);
                ArrayList<String> arrayList2 = new ArrayList<String>();
                arrayList2.add(EMUserInfo.EMUserInfoType.NICKNAME.getDesc());
                arrayList2.add(EMUserInfo.EMUserInfoType.EMAIL.getDesc());
                arrayList2.add(EMUserInfo.EMUserInfoType.PHONE.getDesc());
                arrayList2.add(EMUserInfo.EMUserInfoType.GENDER.getDesc());
                arrayList2.add(EMUserInfo.EMUserInfoType.AVATAR_URL.getDesc());
                arrayList2.add(EMUserInfo.EMUserInfoType.SIGN.getDesc());
                arrayList2.add(EMUserInfo.EMUserInfoType.BIRTH.getDesc());
                arrayList2.add(EMUserInfo.EMUserInfoType.EXT.getDesc());
                EMLog.d(EMUserInfoManager.TAG, "fetchUserInfoByUserId param: " + ((Object)arrayList).toString() + "  " + ((Object)arrayList2).toString());
                String string = EMUserInfoManager.this.emaObject.fetchUserInfoByAttribute(arrayList, arrayList2, eMAError);
                if (callBack == null) {
                    return;
                }
                EMLog.d(EMUserInfoManager.TAG, "fetchUserInfoByUserId response: " + string);
                if (eMAError.errCode() == 0) {
                    EMLog.d(EMUserInfoManager.TAG, "fetchUserInfoByUserId success");
                    HashMap<String, EMUserInfo> hashMap = new HashMap<String, EMUserInfo>();
                    if (string != null && string.length() > 0) {
                        try {
                            JSONObject jSONObject = new JSONObject(string);
                            for (String string2 : userIds) {
                                JSONObject jSONObject2 = jSONObject.getJSONObject(string2);
                                if (jSONObject2 == null) continue;
                                EMUserInfo eMUserInfo = new EMUserInfo();
                                eMUserInfo.setNickName(jSONObject2.optString(EMUserInfo.EMUserInfoType.NICKNAME.getDesc()));
                                String string3 = jSONObject2.optString(EMUserInfo.EMUserInfoType.GENDER.getDesc());
                                if (string3 != null && string3.length() > 0) {
                                    try {
                                        eMUserInfo.setGender(Integer.parseInt(string3));
                                    }
                                    catch (Exception exception) {
                                        eMUserInfo.setGender(0);
                                    }
                                }
                                eMUserInfo.setEmail(jSONObject2.optString(EMUserInfo.EMUserInfoType.EMAIL.getDesc()));
                                eMUserInfo.setPhoneNumber(jSONObject2.optString(EMUserInfo.EMUserInfoType.PHONE.getDesc()));
                                eMUserInfo.setSignature(jSONObject2.optString(EMUserInfo.EMUserInfoType.SIGN.getDesc()));
                                eMUserInfo.setAvatarUrl(jSONObject2.optString(EMUserInfo.EMUserInfoType.AVATAR_URL.getDesc()));
                                eMUserInfo.setExt(jSONObject2.optString(EMUserInfo.EMUserInfoType.EXT.getDesc()));
                                eMUserInfo.setBirth(jSONObject2.optString(EMUserInfo.EMUserInfoType.BIRTH.getDesc()));
                                eMUserInfo.setUserId(string2);
                                hashMap.put(string2, eMUserInfo);
                            }
                        }
                        catch (JSONException jSONException) {
                            eMAError.errMsg();
                        }
                        callBack.onSuccess(hashMap);
                    } else {
                        EMLog.e(EMUserInfoManager.TAG, "fetchUserInfoByUserId response is null");
                        callBack.onSuccess(null);
                    }
                } else {
                    callBack.onError(eMAError.errCode(), eMAError.errMsg());
                    EMLog.e(EMUserInfoManager.TAG, "fetchUserInfoByUserId failed error:" + eMAError.errCode() + "  errorMessage:" + eMAError.errMsg());
                }
            }
        });
    }

    public void fetchUserInfoByAttribute(final String[] userIds, final EMUserInfo.EMUserInfoType[] attributes, final EMValueCallBack<Map<String, EMUserInfo>> callBack) {
        EMLog.d(TAG, "start fetchUserInfoByAttribute");
        if (userIds == null || userIds.length == 0) {
            EMLog.d(TAG, "fetchUserInfoByUserId userIds is empty");
            callBack.onError(205, "userIds is empty");
            return;
        }
        if (attributes == null || attributes.length == 0) {
            EMLog.d(TAG, "fetchUserInfoByUserId attributes is empty");
            callBack.onError(205, "attributes is empty");
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                EMAError eMAError = new EMAError();
                ArrayList<String> arrayList = new ArrayList<String>();
                Collections.addAll(arrayList, userIds);
                ArrayList<String> arrayList2 = new ArrayList<String>();
                for (EMUserInfo.EMUserInfoType stringArray : attributes) {
                    arrayList2.add(stringArray.getDesc());
                }
                EMLog.d(EMUserInfoManager.TAG, "fetchUserInfoByAttribute param: " + ((Object)arrayList).toString() + "  " + ((Object)arrayList2).toString());
                String string = EMUserInfoManager.this.emaObject.fetchUserInfoByAttribute(arrayList, arrayList2, eMAError);
                EMLog.d(EMUserInfoManager.TAG, "fetchUserInfoByAttribute response: " + (String)string);
                if (callBack == null) {
                    return;
                }
                if (eMAError.errCode() == 0) {
                    EMLog.d(EMUserInfoManager.TAG, "fetchUserInfoByAttribute success");
                    HashMap<String, EMUserInfo> hashMap = new HashMap<String, EMUserInfo>();
                    if (string != null && string.length() > 0) {
                        try {
                            JSONObject jSONObject = new JSONObject(string);
                            for (String string2 : userIds) {
                                JSONObject jSONObject2 = jSONObject.getJSONObject(string2);
                                if (jSONObject2 == null) continue;
                                EMUserInfo eMUserInfo = new EMUserInfo();
                                eMUserInfo.setNickName(jSONObject2.optString(EMUserInfo.EMUserInfoType.NICKNAME.getDesc()));
                                String string3 = jSONObject2.optString(EMUserInfo.EMUserInfoType.GENDER.getDesc());
                                if (string3 != null && string3.length() > 0) {
                                    eMUserInfo.setGender(Integer.valueOf(string3));
                                }
                                eMUserInfo.setEmail(jSONObject2.optString(EMUserInfo.EMUserInfoType.EMAIL.getDesc()));
                                eMUserInfo.setPhoneNumber(jSONObject2.optString(EMUserInfo.EMUserInfoType.PHONE.getDesc()));
                                eMUserInfo.setSignature(jSONObject2.optString(EMUserInfo.EMUserInfoType.SIGN.getDesc()));
                                eMUserInfo.setAvatarUrl(jSONObject2.optString(EMUserInfo.EMUserInfoType.AVATAR_URL.getDesc()));
                                eMUserInfo.setExt(jSONObject2.optString(EMUserInfo.EMUserInfoType.EXT.getDesc()));
                                eMUserInfo.setBirth(jSONObject2.optString(EMUserInfo.EMUserInfoType.BIRTH.getDesc()));
                                eMUserInfo.setUserId(string2);
                                hashMap.put(string2, eMUserInfo);
                            }
                        }
                        catch (JSONException jSONException) {
                            eMAError.errMsg();
                        }
                        callBack.onSuccess(hashMap);
                    } else {
                        EMLog.d(EMUserInfoManager.TAG, "fetchUserInfoByAttribute response is null ");
                        callBack.onSuccess(null);
                    }
                } else {
                    callBack.onError(eMAError.errCode(), eMAError.errMsg());
                    EMLog.e(EMUserInfoManager.TAG, "fetchUserInfoByAttribute failed error:" + eMAError.errCode() + "  errorMessage:" + eMAError.errMsg());
                }
            }
        });
    }
}

