/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.hyphenate.chat.EMFileMessageBody;
import com.hyphenate.chat.adapter.message.EMAFileMessageBody;
import com.hyphenate.chat.adapter.message.EMAVideoMessageBody;
import com.hyphenate.util.EMFileHelper;
import com.hyphenate.util.EMLog;

public class EMVideoMessageBody
extends EMFileMessageBody
implements Parcelable {
    private static final String TAG = EMVideoMessageBody.class.getSimpleName();
    public static final Parcelable.Creator<EMVideoMessageBody> CREATOR = new Parcelable.Creator<EMVideoMessageBody>(){

        public EMVideoMessageBody[] newArray(int size) {
            return new EMVideoMessageBody[size];
        }

        public EMVideoMessageBody createFromParcel(Parcel in) {
            return new EMVideoMessageBody(in);
        }
    };

    public EMVideoMessageBody() {
        super("", 2);
    }

    public EMVideoMessageBody(EMAVideoMessageBody body) {
        super(body);
    }

    public EMVideoMessageBody(String videoFilePath, String thumbPath, int duration, long filelength) {
        this(EMFileHelper.getInstance().formatInUri(videoFilePath), EMFileHelper.getInstance().formatInUri(thumbPath), duration, filelength);
        EMLog.d("EMClient", "EMVideoMessageBody thumbPath = " + thumbPath);
    }

    public EMVideoMessageBody(Uri videoFilePath, Uri thumbPath, int duration, long filelength) {
        super(videoFilePath, 2);
        ((EMAVideoMessageBody)this.emaObject).setThumbnailLocalPath(EMFileHelper.getInstance().formatInUriToString(thumbPath));
        ((EMAVideoMessageBody)this.emaObject).setDuration(duration);
        ((EMAVideoMessageBody)this.emaObject).setDisplayName(EMFileHelper.getInstance().getFilename(videoFilePath));
        ((EMAVideoMessageBody)this.emaObject).setFileLength(filelength);
        EMLog.d("videomsg", "create video, message body for:" + videoFilePath + " filename = " + EMFileHelper.getInstance().getFilename(videoFilePath));
        EMLog.d("EMClient", "EMVideoMessageBody thumbPath = " + thumbPath);
    }

    EMVideoMessageBody(String fileName, String remoteUrl, String thumbnailUrl, int length) {
        super(fileName, 2);
        ((EMAVideoMessageBody)this.emaObject).setThumbnailLocalPath(thumbnailUrl);
        ((EMAVideoMessageBody)this.emaObject).setLocalPath(fileName);
        ((EMAVideoMessageBody)this.emaObject).setRemotePath(remoteUrl);
        ((EMAVideoMessageBody)this.emaObject).setThumbnailRemotePath(thumbnailUrl);
        ((EMAVideoMessageBody)this.emaObject).setFileLength(length);
    }

    public long getVideoFileLength() {
        return ((EMAVideoMessageBody)this.emaObject).fileLength();
    }

    public void setVideoFileLength(long filelength) {
        ((EMAVideoMessageBody)this.emaObject).setFileLength(filelength);
    }

    public String getThumbnailUrl() {
        return ((EMAVideoMessageBody)this.emaObject).thumbnailRemotePath();
    }

    public void setThumbnailUrl(String thumbnailUrl) {
        ((EMAVideoMessageBody)this.emaObject).setThumbnailRemotePath(thumbnailUrl);
    }

    public void setThumbnailSize(int width, int height) {
        ((EMAVideoMessageBody)this.emaObject).setSize(width, height);
    }

    public int getThumbnailWidth() {
        return ((EMAVideoMessageBody)this.emaObject).width();
    }

    public int getThumbnailHeight() {
        return ((EMAVideoMessageBody)this.emaObject).height();
    }

    public String getLocalThumb() {
        return EMFileHelper.getInstance().formatOutLocalUrl(((EMAVideoMessageBody)this.emaObject).thumbnailLocalPath());
    }

    public Uri getLocalThumbUri() {
        return EMFileHelper.getInstance().formatOutUri(((EMAVideoMessageBody)this.emaObject).thumbnailLocalPath());
    }

    public void setLocalThumb(String localThumbPath) {
        ((EMAVideoMessageBody)this.emaObject).setThumbnailLocalPath(EMFileHelper.getInstance().formatInUriToString(localThumbPath));
    }

    public void setLocalThumb(Uri localThumbPath) {
        ((EMAVideoMessageBody)this.emaObject).setThumbnailLocalPath(EMFileHelper.getInstance().formatInUriToString(localThumbPath));
    }

    public int getDuration() {
        return ((EMAVideoMessageBody)this.emaObject).duration();
    }

    public String toString() {
        return "video: " + ((EMAVideoMessageBody)this.emaObject).displayName() + ", localUrl: " + ((EMAVideoMessageBody)this.emaObject).getLocalUrl() + ", remoteUrl: " + ((EMAVideoMessageBody)this.emaObject).getRemoteUrl() + ", thumbnailUrl: " + ((EMAVideoMessageBody)this.emaObject).thumbnailLocalPath() + ", length: " + ((EMAVideoMessageBody)this.emaObject).fileLength();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(((EMAVideoMessageBody)this.emaObject).displayName());
        dest.writeString(((EMAVideoMessageBody)this.emaObject).getLocalUrl());
        dest.writeString(((EMAVideoMessageBody)this.emaObject).getRemoteUrl());
        dest.writeString(((EMAVideoMessageBody)this.emaObject).thumbnailLocalPath());
        dest.writeString(((EMAVideoMessageBody)this.emaObject).thumbnailLocalPath());
        dest.writeInt(((EMAVideoMessageBody)this.emaObject).duration());
        dest.writeLong(((EMAVideoMessageBody)this.emaObject).fileLength());
        dest.writeInt(((EMAVideoMessageBody)this.emaObject).width());
        dest.writeInt(((EMAVideoMessageBody)this.emaObject).height());
    }

    private EMVideoMessageBody(Parcel in) {
        super("", 2);
        ((EMAVideoMessageBody)this.emaObject).setDisplayName(in.readString());
        ((EMAVideoMessageBody)this.emaObject).setLocalPath(in.readString());
        ((EMAVideoMessageBody)this.emaObject).setRemotePath(in.readString());
        ((EMAVideoMessageBody)this.emaObject).setThumbnailRemotePath(in.readString());
        ((EMAVideoMessageBody)this.emaObject).setThumbnailLocalPath(in.readString());
        ((EMAVideoMessageBody)this.emaObject).setDuration(in.readInt());
        ((EMAVideoMessageBody)this.emaObject).setFileLength(in.readLong());
        int n = in.readInt();
        int n2 = in.readInt();
        ((EMAVideoMessageBody)this.emaObject).setSize(n, n2);
    }

    public String getThumbnailSecret() {
        return ((EMAVideoMessageBody)this.emaObject).thumbnailSecretKey();
    }

    public void setThumbnailSecret(String secret) {
        ((EMAVideoMessageBody)this.emaObject).setThumbnailSecretKey(secret);
    }

    public EMFileMessageBody.EMDownloadStatus thumbnailDownloadStatus() {
        EMAFileMessageBody.EMADownloadStatus eMADownloadStatus = ((EMAVideoMessageBody)this.emaObject).thumbnailDownloadStatus();
        switch (eMADownloadStatus) {
            case DOWNLOADING: {
                return EMFileMessageBody.EMDownloadStatus.DOWNLOADING;
            }
            case SUCCESSED: {
                return EMFileMessageBody.EMDownloadStatus.SUCCESSED;
            }
            case FAILED: {
                return EMFileMessageBody.EMDownloadStatus.FAILED;
            }
            case PENDING: {
                return EMFileMessageBody.EMDownloadStatus.PENDING;
            }
        }
        return EMFileMessageBody.EMDownloadStatus.SUCCESSED;
    }

    public void setThumbnailDownloadStatus(EMFileMessageBody.EMDownloadStatus status) {
        ((EMAVideoMessageBody)this.emaObject).setThumbnailDownloadStatus(EMAFileMessageBody.EMADownloadStatus.valueOf(status.name()));
    }
}

