/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.hyphenate.chat.EMFileMessageBody;
import com.hyphenate.chat.adapter.message.EMAVoiceMessageBody;
import com.hyphenate.util.EMFileHelper;
import com.hyphenate.util.EMLog;
import java.io.File;

public class EMVoiceMessageBody
extends EMFileMessageBody
implements Parcelable {
    public static final Parcelable.Creator<EMVoiceMessageBody> CREATOR = new Parcelable.Creator<EMVoiceMessageBody>(){

        public EMVoiceMessageBody createFromParcel(Parcel in) {
            return new EMVoiceMessageBody(in);
        }

        public EMVoiceMessageBody[] newArray(int size) {
            return new EMVoiceMessageBody[size];
        }
    };

    public EMVoiceMessageBody(File voiceFile, int duration) {
        this(Uri.fromFile((File)voiceFile), duration);
    }

    public EMVoiceMessageBody(Uri voiceFile, int duration) {
        super(voiceFile, 4);
        ((EMAVoiceMessageBody)this.emaObject).setDuration(duration);
        ((EMAVoiceMessageBody)this.emaObject).setDisplayName(EMFileHelper.getInstance().getFilename(voiceFile));
        EMLog.d("voicemsg", "create voice, message body for:" + voiceFile);
    }

    public EMVoiceMessageBody(EMAVoiceMessageBody body) {
        super(body);
    }

    EMVoiceMessageBody(String fileName, String remoteUrl, int length) {
        super(fileName, 4);
        ((EMAVoiceMessageBody)this.emaObject).setLocalPath(fileName);
        ((EMAVoiceMessageBody)this.emaObject).setRemotePath(remoteUrl);
        ((EMAVoiceMessageBody)this.emaObject).setDuration(length);
    }

    public int getLength() {
        return ((EMAVoiceMessageBody)this.emaObject).duration();
    }

    public long getFileSize() {
        return ((EMAVoiceMessageBody)this.emaObject).fileLength();
    }

    public String toString() {
        return "voice:" + ((EMAVoiceMessageBody)this.emaObject).displayName() + ",localurl:" + ((EMAVoiceMessageBody)this.emaObject).getLocalUrl() + ",remoteurl:" + ((EMAVoiceMessageBody)this.emaObject).getRemoteUrl() + ",length:" + ((EMAVoiceMessageBody)this.emaObject).duration();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(((EMAVoiceMessageBody)this.emaObject).displayName());
        dest.writeString(((EMAVoiceMessageBody)this.emaObject).getLocalUrl());
        dest.writeString(((EMAVoiceMessageBody)this.emaObject).getRemoteUrl());
        dest.writeInt(((EMAVoiceMessageBody)this.emaObject).duration());
    }

    private EMVoiceMessageBody(Parcel in) {
        super("", 4);
        ((EMAVoiceMessageBody)this.emaObject).setDisplayName(in.readString());
        ((EMAVoiceMessageBody)this.emaObject).setLocalPath(in.readString());
        ((EMAVoiceMessageBody)this.emaObject).setRemotePath(in.readString());
        ((EMAVoiceMessageBody)this.emaObject).setDuration(in.readInt());
    }
}

