/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat.adapter;

import com.hyphenate.chat.EMCursorResult;
import com.hyphenate.chat.adapter.EMABase;
import com.hyphenate.chat.adapter.EMAChatManagerListener;
import com.hyphenate.chat.adapter.EMAConversation;
import com.hyphenate.chat.adapter.EMAEncryptProviderInterface;
import com.hyphenate.chat.adapter.EMAError;
import com.hyphenate.chat.adapter.EMAGroupReadAck;
import com.hyphenate.chat.adapter.message.EMAMessage;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class EMAChatManager
extends EMABase {
    private Set<EMAChatManagerListener> listeners = new HashSet<EMAChatManagerListener>();

    public void sendMessage(EMAMessage msg) {
        this.nativeSendMessage(msg);
    }

    public void recallMessage(EMAMessage msg, EMAError error) {
        this.nativeRecallMessage(msg, error);
    }

    public void sendReadAckForConversation(String conversationId, EMAError error) {
        this.nativeSendReadAckForConversation(conversationId, error);
    }

    public void sendReadAckForMessage(EMAMessage msg) {
        this.nativeSendReadAckForMessage(msg);
    }

    public void sendReadAckForGroupMessage(EMAMessage msg, String ext) {
        this.nativeSendReadAckForGroupMessage(msg, ext);
    }

    public void resendMessage(EMAMessage msg) {
        this.nativeResendMessage(msg);
    }

    public void downloadMessageThumbnail(EMAMessage msg) {
        this.nativeDownloadMessageThumbnail(msg);
    }

    public void downloadMessageAttachments(EMAMessage msg) {
        this.nativeDownloadMessageAttachments(msg);
    }

    public void removeConversation(String conversationId, boolean isRemoveMessages, boolean isThread) {
        this.nativeRemoveConversation(conversationId, isRemoveMessages, isThread);
    }

    public EMAError deleteConversationFromServer(String conversationId, EMAConversation.EMAConversationType type, boolean isDeleteServerMessages) {
        return this.nativeDeleteConversationFromServer(conversationId, type.ordinal(), isDeleteServerMessages);
    }

    public EMAConversation conversationWithType(String conversationId, EMAConversation.EMAConversationType type, boolean createIfNotExist, boolean isThread) {
        return this.nativeConversationWithType(conversationId, type.ordinal(), createIfNotExist, isThread);
    }

    public List<EMAConversation> getConversations() {
        return this.nativeGetConversations();
    }

    public List<EMAConversation> fetchConversationsFromServer(EMAError error) {
        return this.nativeFetchConversationsFromServer(error);
    }

    public List<EMAConversation> loadAllConversationsFromDB() {
        return this.nativeLoadAllConversationsFromDB();
    }

    public void addListener(EMAChatManagerListener listener) {
        this.listeners.add(listener);
        this.nativeAddListener(listener);
    }

    public void removeListener(EMAChatManagerListener listener) {
        this.listeners.remove(listener);
        this.nativeRemoveListener(listener);
    }

    public void clearListeners() {
        this.listeners.clear();
        this.nativeClearListeners();
    }

    public void setEncryptProvider(EMAEncryptProviderInterface provider) {
        this.nativeSetEncryptProvider(provider);
    }

    public EMAEncryptProviderInterface getEncryptProvider(boolean createIfNotExist) {
        return this.nativeGetEncryptProvider(createIfNotExist);
    }

    public EMAMessage getMessage(String messageId) {
        return this.nativeGetMessage(messageId);
    }

    public void uploadLog() {
        this.nativeUploadLog();
    }

    native void nativeSendMessage(EMAMessage var1);

    native void nativeRecallMessage(EMAMessage var1, EMAError var2);

    native void nativeSendReadAckForConversation(String var1, EMAError var2);

    native void nativeSendReadAckForMessage(EMAMessage var1);

    native void nativeSendReadAckForGroupMessage(EMAMessage var1, String var2);

    native void nativeResendMessage(EMAMessage var1);

    native void nativeDownloadMessageThumbnail(EMAMessage var1);

    native void nativeDownloadMessageAttachments(EMAMessage var1);

    native void nativeRemoveConversation(String var1, boolean var2, boolean var3);

    native EMAError nativeDeleteConversationFromServer(String var1, int var2, boolean var3);

    native EMAConversation nativeConversationWithType(String var1, int var2, boolean var3, boolean var4);

    native List<EMAConversation> nativeGetConversations();

    native List<EMAConversation> nativeFetchConversationsFromServer(EMAError var1);

    native List<EMAConversation> nativeLoadAllConversationsFromDB();

    native void nativeAddListener(EMAChatManagerListener var1);

    native void nativeRemoveListener(EMAChatManagerListener var1);

    native void nativeClearListeners();

    native void nativeSetEncryptProvider(EMAEncryptProviderInterface var1);

    native EMAEncryptProviderInterface nativeGetEncryptProvider(boolean var1);

    native EMAMessage nativeGetMessage(String var1);

    native void nativeUploadLog();

    protected EMAChatManager() {
    }

    protected EMAChatManager(EMAChatManager manager) {
        this.nativeInit(manager);
    }

    native void nativeInit(EMAChatManager var1);

    public boolean updateParticipant(String from, String changeTo) {
        return this.nativeUpdateParticipant(from, changeTo);
    }

    native boolean nativeUpdateParticipant(String var1, String var2);

    public EMCursorResult<EMAGroupReadAck> fetchGroupReadAcks(String msgId, String groupId, EMAError error, int pageSize, String startAckId) {
        return this.nativeFetchGroupReadAcks(msgId, groupId, error, pageSize, startAckId);
    }

    public EMCursorResult<EMAMessage> fetchHistoryMessages(String conversationId, int type, int pageSize, String startMsgId, EMAConversation.EMASearchDirection direction, EMAError error) {
        return this.nativeFetchHistoryMessages(conversationId, type, pageSize, startMsgId, direction.ordinal(), error);
    }

    native EMCursorResult<EMAGroupReadAck> nativeFetchGroupReadAcks(String var1, String var2, EMAError var3, int var4, String var5);

    native EMCursorResult<EMAMessage> nativeFetchHistoryMessages(String var1, int var2, int var3, String var4, int var5, EMAError var6);

    public List<EMAMessage> searchMessages(int type, long timeStamp, int maxCount, String from, EMAConversation.EMASearchDirection direction) {
        return this.nativeSearchMessages(type, timeStamp, maxCount, from, direction.ordinal());
    }

    public List<EMAMessage> searchMessages(String keywords, long timeStamp, int maxCount, String from, EMAConversation.EMASearchDirection direction) {
        return this.nativeSearchMessages(keywords, timeStamp, maxCount, from, direction.ordinal());
    }

    native List<EMAMessage> nativeSearchMessages(int var1, long var2, int var4, String var5, int var6);

    native List<EMAMessage> nativeSearchMessages(String var1, long var2, int var4, String var5, int var6);

    public boolean removeMessagesBeforeTimestamp(long timeStamp) {
        return this.nativeRemoveMessagesBeforeTimestamp(timeStamp);
    }

    native boolean nativeRemoveMessagesBeforeTimestamp(long var1);

    public void reportMessage(String msgId, String reportTarget, String reportReason, EMAError error) {
        this.nativeReportMessage(msgId, reportTarget, reportReason, error);
    }

    native void nativeReportMessage(String var1, String var2, String var3, EMAError var4);

    public List<List<String>> fetchSupportLanguages(EMAError error) {
        return this.nativeFetchSupportLanguages(error);
    }

    native List<List<String>> nativeFetchSupportLanguages(EMAError var1);

    public EMAMessage translateMessage(EMAMessage msg, List<String> languages, EMAError error) {
        return this.nativeTranslateMessage(msg, languages, error);
    }

    native EMAMessage nativeTranslateMessage(EMAMessage var1, List<String> var2, EMAError var3);
}

