/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.push;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.support.annotation.NonNull;
import android.util.Pair;
import com.hyphenate.chat.EMClient;
import com.hyphenate.cloud.EMHttpClient;
import com.hyphenate.push.EMPushConfig;
import com.hyphenate.push.EMPushType;
import com.hyphenate.push.PushListener;
import com.hyphenate.push.platform.mi.a;
import com.hyphenate.util.DeviceUuidFactory;
import com.hyphenate.util.EMLog;
import java.util.ArrayList;
import java.util.Random;
import org.json.JSONObject;

public class EMPushHelper {
    private static final String a = "EMPushHelper";
    private static final int b = 3;
    private static final int c = 0;
    private static final int d = 1;
    private Context e;
    private EMPushConfig f;
    private com.hyphenate.push.platform.a g;
    private Handler h;
    private EMPushType i;
    private String j;
    private boolean k;
    private final Object l = new Object();
    private final Object m = new Object();
    private PushListener n;
    private boolean o = false;

    private EMPushHelper() {
        HandlerThread handlerThread = new HandlerThread("token-uploader");
        handlerThread.start();
        this.h = new Handler(handlerThread.getLooper()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 0: {
                        Object object = EMPushHelper.this.l;
                        synchronized (object) {
                            boolean bl;
                            String string = (String)msg.obj;
                            boolean bl2 = EMPushHelper.this.a(EMPushHelper.this.g.a(), string);
                            if (bl2) {
                                this.removeMessages(0);
                                return;
                            }
                            boolean bl3 = bl = !this.hasMessages(0);
                            if (bl) {
                                EMPushHelper.this.onErrorResponse(EMPushHelper.this.i, 1501L);
                                EMPushHelper.this.a(EMPushType.NORMAL);
                            }
                            break;
                        }
                    }
                    case 1: {
                        EMPushHelper.this.k = EMPushHelper.this.a(EMPushHelper.this.g.a(), "");
                        if (!EMPushHelper.this.k) {
                            EMPushHelper.this.onErrorResponse(EMPushHelper.this.i, 1502L);
                        }
                        Object object = EMPushHelper.this.m;
                        synchronized (object) {
                            EMPushHelper.this.m.notifyAll();
                            break;
                        }
                    }
                    default: {
                        super.handleMessage(msg);
                    }
                }
            }
        };
    }

    public static EMPushHelper getInstance() {
        return InstanceHolder.a;
    }

    public void setPushListener(PushListener callback) {
        this.n = callback;
    }

    public void init(Context context, EMPushConfig config) {
        EMLog.e(a, "EMPushHelper init, config: " + config.toString());
        if (context == null || config == null) {
            throw new IllegalArgumentException("Null parameters, context=" + context + ", config=" + config);
        }
        this.e = context.getApplicationContext();
        this.f = config;
    }

    public void register() {
        if (this.e == null || this.f == null) {
            EMLog.e(a, "EMPushHelper#init(Context, EMPushConfig) method not call previously.");
            return;
        }
        EMPushType eMPushType = this.a(this.f);
        EMLog.e(a, "EMPushHelper register, prefer push type: " + (Object)((Object)eMPushType));
        this.a(eMPushType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregister(boolean unbindToken) {
        EMLog.e(a, "EMPushHelper unregister, unbind token: " + unbindToken);
        if (!this.o) {
            EMLog.e(a, "EMPushHelper is not registered previously, return true directly.");
            return true;
        }
        this.o = false;
        this.g.a(this.e);
        this.h.removeMessages(0);
        if (!unbindToken) {
            this.i = null;
            return true;
        }
        this.a();
        Object object = this.m;
        synchronized (object) {
            try {
                this.m.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.k) {
            this.i = null;
        }
        EMLog.e(a, "Push type after unregister is " + (Object)((Object)this.i));
        return this.k;
    }

    private boolean a(EMPushType eMPushType, String string) {
        String string2 = EMPushHelper.getInstance().getPushTokenWithType(eMPushType);
        if (string2 == null || !string2.equals(string)) {
            EMPushHelper.getInstance().setPushTokenWithType(eMPushType, string);
            return true;
        }
        return false;
    }

    public void onReceiveToken(EMPushType type, String token) {
        EMLog.e(a, "onReceiveToken: " + (Object)((Object)type) + " - " + token);
        if (!this.o) {
            EMLog.e(a, "EMPushHelper is not registered, abort token upload action.");
            return;
        }
        this.j = token;
        if (this.a(type, token)) {
            EMLog.d(a, "push token changed, upload to server");
            this.a(token);
            return;
        }
        if (EMClient.getInstance().getChatConfigPrivate().I()) {
            EMLog.d(a, "push token not change, but last login is not on this device, upload to server");
            this.a(token);
        } else {
            EMLog.e(a, "EMPushHelper not first login, ignore token upload action.");
        }
    }

    public void onErrorResponse(EMPushType type, long resultCode) {
        EMLog.e(a, "onErrorResponse: " + (Object)((Object)type) + " - " + resultCode);
        if (!this.o) {
            EMLog.e(a, "EMPushHelper is not registered, abort error response action.");
            return;
        }
        if (resultCode == 1500L) {
            this.a(EMPushType.NORMAL);
        }
        if (this.n != null) {
            this.n.onError(type, resultCode);
        }
    }

    public EMPushType getPushType() {
        return this.i;
    }

    public String getPushToken() {
        return this.j;
    }

    public String getFCMPushToken() {
        return com.hyphenate.chat.core.a.a().m();
    }

    public void setFCMPushToken(String token) {
        com.hyphenate.chat.core.a.a().d(token);
    }

    public String getPushTokenWithType(EMPushType type) {
        return com.hyphenate.chat.core.a.a().a(type);
    }

    public void setPushTokenWithType(EMPushType type, String token) {
        com.hyphenate.chat.core.a.a().a(type, token);
    }

    private void a(@NonNull EMPushType eMPushType) {
        if (this.i == eMPushType) {
            EMLog.e(a, "Push type " + (Object)((Object)eMPushType) + " no change, return. ");
            return;
        }
        if (this.g != null) {
            EMLog.e(a, (Object)((Object)this.g.b()) + " push already exists, unregister it and change to " + (Object)((Object)eMPushType) + " push.");
            this.g.a(this.e);
        }
        this.i = eMPushType;
        switch (eMPushType) {
            case FCM: {
                this.g = new com.hyphenate.push.platform.a.a();
                break;
            }
            case MIPUSH: {
                this.g = new a();
                break;
            }
            case OPPOPUSH: {
                this.g = new com.hyphenate.push.platform.oppo.a();
                break;
            }
            case VIVOPUSH: {
                this.g = new com.hyphenate.push.platform.vivo.a();
                break;
            }
            case MEIZUPUSH: {
                this.g = new com.hyphenate.push.platform.meizu.a();
                break;
            }
            case HMSPUSH: {
                this.g = new com.hyphenate.push.platform.b.a();
                break;
            }
            default: {
                this.g = new com.hyphenate.push.platform.c.a();
            }
        }
        this.o = true;
        this.g.a(this.e, this.f, this.n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(String string) {
        this.h.removeMessages(0);
        Object object = this.l;
        synchronized (object) {
            for (int i = -1; i < 3; ++i) {
                Message message = this.h.obtainMessage(0, (Object)string);
                if (i == -1) {
                    this.h.sendMessage(message);
                    continue;
                }
                int n = this.randomDelay(i);
                EMLog.i(a, "Retry upload after " + n + "s if failed.");
                this.h.sendMessageDelayed(message, (long)(n * 1000));
            }
        }
    }

    private void a() {
        this.h.obtainMessage(1).sendToTarget();
    }

    private boolean a(String string, String string2) {
        String string3 = EMClient.getInstance().getChatConfigPrivate().a(true, false) + "/users/" + EMClient.getInstance().getCurrentUser();
        DeviceUuidFactory deviceUuidFactory = new DeviceUuidFactory(EMClient.getInstance().getContext());
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("device_token", (Object)string2);
            jSONObject.put("notifier_name", (Object)string);
            jSONObject.put("device_id", (Object)deviceUuidFactory.getDeviceUuid().toString());
        }
        catch (Exception exception) {
            EMLog.e(a, "uploadTokenInternal put json exception: " + exception.toString());
        }
        int n = 2;
        do {
            try {
                EMLog.e(a, "uploadTokenInternal, token=" + string2 + ", url=" + string3 + ", notifier name=" + string);
                Pair<Integer, String> pair = EMHttpClient.getInstance().sendRequestWithToken(string3, jSONObject.toString(), EMHttpClient.PUT);
                int n2 = (Integer)pair.first;
                String string4 = (String)pair.second;
                if (n2 == 200) {
                    EMLog.e(a, "uploadTokenInternal success.");
                    return true;
                }
                EMLog.e(a, "uploadTokenInternal failed: " + string4);
                string3 = EMClient.getInstance().getChatConfigPrivate().a(true, true) + "/users/" + EMClient.getInstance().getCurrentUser();
            }
            catch (Exception exception) {
                EMLog.e(a, "uploadTokenInternal exception: " + exception.toString());
                string3 = EMClient.getInstance().getChatConfigPrivate().a(true, true) + "/users/" + EMClient.getInstance().getCurrentUser();
            }
        } while (--n > 0);
        return false;
    }

    private EMPushType a(EMPushConfig eMPushConfig) {
        EMPushType[] eMPushTypeArray = new EMPushType[]{EMPushType.FCM, EMPushType.MIPUSH, EMPushType.HMSPUSH, EMPushType.MEIZUPUSH, EMPushType.OPPOPUSH, EMPushType.VIVOPUSH};
        ArrayList<EMPushType> arrayList = eMPushConfig.getEnabledPushTypes();
        for (EMPushType eMPushType : eMPushTypeArray) {
            if (!arrayList.contains((Object)eMPushType) || !this.a(eMPushType, eMPushConfig)) continue;
            return eMPushType;
        }
        return EMPushType.NORMAL;
    }

    private boolean a(EMPushType eMPushType, EMPushConfig eMPushConfig) {
        boolean bl = this.n != null ? this.n.isSupportPush(eMPushType, eMPushConfig) : com.hyphenate.push.a.a.a(eMPushType, eMPushConfig);
        EMLog.i(a, "isSupportPush: " + (Object)((Object)eMPushType) + " - " + bl);
        return bl;
    }

    public int randomDelay(int attempts) {
        if (attempts == 0) {
            return new Random().nextInt(5) + 1;
        }
        if (attempts == 1) {
            return new Random().nextInt(54) + 6;
        }
        return new Random().nextInt(540) + 60;
    }

    private static class InstanceHolder {
        static EMPushHelper a = new EMPushHelper();

        private InstanceHolder() {
        }
    }
}

