/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.util;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.content.Context;
import android.os.Build;
import android.os.Environment;
import com.hyphenate.util.EMLog;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class EasyUtils {
    public static final String TAG = "EasyUtils";
    private static Hashtable<String, String> resourceTable = new Hashtable();

    public static boolean isAppRunningForeground(Context ctx) {
        ActivityManager activityManager = (ActivityManager)ctx.getSystemService("activity");
        if (Build.VERSION.SDK_INT > 20) {
            List list = activityManager.getRunningAppProcesses();
            if (list == null) {
                return false;
            }
            String string = ctx.getPackageName();
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                if (runningAppProcessInfo.importance != 100 || !runningAppProcessInfo.processName.equals(string)) continue;
                return true;
            }
            return false;
        }
        try {
            List list = activityManager.getRunningTasks(1);
            if (list == null || list.size() < 1) {
                return false;
            }
            boolean bl = ctx.getPackageName().equalsIgnoreCase(((ActivityManager.RunningTaskInfo)list.get((int)0)).baseActivity.getPackageName());
            EMLog.d("utils", "app running in foregroud\uff1a" + bl);
            return bl;
        }
        catch (SecurityException securityException) {
            EMLog.d(TAG, "Apk doesn't hold GET_TASKS permission");
            securityException.printStackTrace();
            return false;
        }
    }

    public static String getTopActivityName(Context ctx) {
        ActivityManager activityManager = (ActivityManager)ctx.getSystemService("activity");
        try {
            List list = activityManager.getRunningTasks(1);
            if (list == null || list.size() < 1) {
                return "";
            }
            return ((ActivityManager.RunningTaskInfo)list.get((int)0)).topActivity.getClassName();
        }
        catch (SecurityException securityException) {
            EMLog.d(TAG, "Apk doesn't hold GET_TASKS permission");
            securityException.printStackTrace();
            return "";
        }
    }

    public static boolean isSingleActivity(Context ctx) {
        ActivityManager activityManager = (ActivityManager)ctx.getSystemService("activity");
        List list = null;
        try {
            list = activityManager.getRunningTasks(1);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        if (list == null || list.size() < 1) {
            return false;
        }
        return ((ActivityManager.RunningTaskInfo)list.get((int)0)).numRunning == 1;
    }

    public static List<String> getRunningApps(Context ctx) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            ActivityManager activityManager = (ActivityManager)ctx.getSystemService("activity");
            List list = activityManager.getRunningAppProcesses();
            if (list == null) {
                return arrayList;
            }
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                String string = runningAppProcessInfo.processName;
                if (string.contains(":")) {
                    string = string.substring(0, string.indexOf(":"));
                }
                if (arrayList.contains(string)) continue;
                arrayList.add(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    @SuppressLint(value={"SimpleDateFormat"})
    public static String getTimeStamp() {
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        return simpleDateFormat.format(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeToZipFile(byte[] data, String filePath) {
        FileOutputStream fileOutputStream = null;
        DeflaterOutputStream deflaterOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(filePath);
            deflaterOutputStream = new GZIPOutputStream(new BufferedOutputStream(fileOutputStream));
            deflaterOutputStream.write(data);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (deflaterOutputStream != null) {
                try {
                    deflaterOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (fileOutputStream != null) {
                try {
                    ((OutputStream)fileOutputStream).close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        if (EMLog.debugMode) {
            File file = new File(filePath);
            DecimalFormat decimalFormat = new DecimalFormat("#.##");
            double d = (double)file.length() / (double)data.length * 100.0;
            double d2 = Double.valueOf(decimalFormat.format(d));
            EMLog.d("zip", "data size:" + data.length + " zip file size:" + file.length() + "zip file ratio%: " + d2);
        }
        return true;
    }

    public static String getAppResourceString(Context context, String stringName) {
        String string = resourceTable.get(stringName);
        if (string != null) {
            return string;
        }
        int n = context.getResources().getIdentifier(stringName, "string", context.getPackageName());
        string = context.getString(n);
        if (string != null) {
            resourceTable.put(stringName, string);
        }
        return string;
    }

    public static String convertByteArrayToString(byte[] input) {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : input) {
            stringBuilder.append(String.format("0x%02X", by));
        }
        return stringBuilder.toString();
    }

    public static boolean isSDCardExist() {
        return Environment.getExternalStorageState().equals("mounted");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(String oldPath, String newPath) {
        boolean bl = true;
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            int n = 0;
            int n2 = 0;
            File file = new File(oldPath);
            if (file.exists()) {
                inputStream = new FileInputStream(oldPath);
                fileOutputStream = new FileOutputStream(newPath);
                byte[] byArray = new byte[1024];
                while ((n2 = inputStream.read(byArray)) != -1) {
                    n += n2;
                    fileOutputStream.write(byArray, 0, n2);
                }
                fileOutputStream.flush();
            } else {
                bl = false;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFolder(String oldPath, String newPath) {
        boolean bl = true;
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            new File(newPath).mkdirs();
            File file = new File(oldPath);
            String[] stringArray = file.list();
            String string = null;
            File file2 = null;
            for (String string2 : stringArray) {
                string = oldPath.endsWith(File.separator) ? oldPath + string2 : oldPath + File.separator + string2;
                file2 = new File(string);
                if (file2.isFile()) {
                    try {
                        int n;
                        fileInputStream = new FileInputStream(file2);
                        fileOutputStream = new FileOutputStream(newPath + "/" + file2.getName());
                        byte[] byArray = new byte[5120];
                        while ((n = fileInputStream.read(byArray)) != -1) {
                            fileOutputStream.write(byArray, 0, n);
                        }
                        fileOutputStream.flush();
                    }
                    catch (Exception exception) {
                        bl = false;
                    }
                    finally {
                        if (fileInputStream != null) {
                            try {
                                fileInputStream.close();
                            }
                            catch (Exception exception) {}
                        }
                        if (fileOutputStream != null) {
                            try {
                                fileOutputStream.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                if (!file2.isDirectory()) continue;
                EasyUtils.copyFolder(oldPath + "/" + string2, newPath + "/" + string2);
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public static String useridFromJid(String memberName) {
        String string = "";
        string = memberName.contains("_") && memberName.contains("@easemob.com") ? memberName.substring(memberName.indexOf("_") + 1, memberName.indexOf("@")) : (memberName.contains("_") ? memberName.substring(memberName.indexOf("_") + 1) : memberName);
        return string;
    }

    public static String getMediaRequestUid(String appKey, String username) {
        return appKey + "_" + username;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate[] convertToCerts(List<String> certschain) {
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        ByteArrayInputStream byteArrayInputStream = null;
        for (int i = 0; i < certschain.size(); ++i) {
            String string = certschain.get(i);
            try {
                byteArrayInputStream = new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8));
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
                arrayList.add(x509Certificate);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                EMLog.e(TAG, exception.getMessage());
                continue;
            }
            finally {
                if (byteArrayInputStream != null) {
                    try {
                        ((InputStream)byteArrayInputStream).close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        }
        X509Certificate[] x509CertificateArray = new X509Certificate[arrayList.size()];
        arrayList.toArray(x509CertificateArray);
        return x509CertificateArray;
    }

    public static X509TrustManager getSystemDefaultTrustManager() {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
            for (int i = 0; i < trustManagerArray.length; ++i) {
                if (!(trustManagerArray[i] instanceof X509TrustManager)) continue;
                return (X509TrustManager)trustManagerArray[i];
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }
}

