/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.util;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.media.ExifInterface;
import android.media.ThumbnailUtils;
import android.net.Uri;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import com.hyphenate.util.EMFileHelper;
import com.hyphenate.util.EMLog;
import com.hyphenate.util.PathUtil;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public class ImageUtils {
    public static final int SCALE_IMAGE_WIDTH = 640;
    public static final int SCALE_IMAGE_HEIGHT = 960;

    public static Bitmap getRoundedCornerBitmap(Bitmap bitmap) {
        return ImageUtils.getRoundedCornerBitmap(bitmap, 6.0f);
    }

    public static Bitmap getRoundedCornerBitmap(Bitmap bitmap, float radius) {
        Bitmap bitmap2 = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap2);
        int n = -12434878;
        Paint paint = new Paint();
        Rect rect = new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight());
        RectF rectF = new RectF(rect);
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(-12434878);
        canvas.drawRoundRect(rectF, radius, radius, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, rect, rect, paint);
        return bitmap2;
    }

    public static Bitmap getVideoThumbnail(String videoPath, int width, int height, int kind) {
        Bitmap bitmap = null;
        bitmap = ThumbnailUtils.createVideoThumbnail((String)videoPath, (int)kind);
        EMLog.d("getVideoThumbnail", "video thumb width:" + bitmap.getWidth());
        EMLog.d("getVideoThumbnail", "video thumb height:" + bitmap.getHeight());
        bitmap = ThumbnailUtils.extractThumbnail((Bitmap)bitmap, (int)width, (int)height, (int)2);
        return bitmap;
    }

    public static String saveVideoThumb(File videoFile, int width, int height, int kind) {
        Bitmap bitmap = ImageUtils.getVideoThumbnail(videoFile.getAbsolutePath(), width, height, kind);
        File file = new File(PathUtil.getInstance().getVideoPath(), "th" + videoFile.getName());
        try {
            file.createNewFile();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fileOutputStream);
        try {
            if (fileOutputStream != null) {
                fileOutputStream.flush();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return file.getAbsolutePath();
    }

    public static Bitmap decodeScaleImage(String imagePath, int reqWidth, int reqHeight) {
        BitmapFactory.Options options = ImageUtils.getBitmapOptions(imagePath);
        int n = ImageUtils.calculateInSampleSize(options, reqWidth, reqHeight);
        EMLog.d("img", "original wid" + options.outWidth + " original height:" + options.outHeight + " sample:" + n);
        options.inSampleSize = n;
        options.inJustDecodeBounds = false;
        Bitmap bitmap = BitmapFactory.decodeFile((String)imagePath, (BitmapFactory.Options)options);
        int n2 = ImageUtils.readPictureDegree(imagePath);
        Bitmap bitmap2 = null;
        if (bitmap != null && n2 != 0) {
            bitmap2 = ImageUtils.rotateImageView(n2, bitmap);
            bitmap.recycle();
            bitmap = null;
            return bitmap2;
        }
        return bitmap;
    }

    @RequiresApi(api=24)
    public static Bitmap decodeScaleImage(Context context, Uri imageUri, int reqWidth, int reqHeight) throws IOException {
        BitmapFactory.Options options = ImageUtils.getBitmapOptions(context, imageUri);
        int n = ImageUtils.calculateInSampleSize(options, reqWidth, reqHeight);
        EMLog.d("img", "original wid" + options.outWidth + " original height:" + options.outHeight + " sample:" + n);
        options.inSampleSize = n;
        options.inJustDecodeBounds = false;
        Bitmap bitmap = ImageUtils.getBitmapByUri(context, imageUri, options);
        int n2 = ImageUtils.readPictureDegree(context, imageUri);
        Bitmap bitmap2 = null;
        if (bitmap != null && n2 != 0) {
            bitmap2 = ImageUtils.rotateImageView(n2, bitmap);
            bitmap.recycle();
            bitmap = null;
            return bitmap2;
        }
        return bitmap;
    }

    public static Bitmap decodeScaleImage(Context context, int drawableId, int reqWidth, int reqHeight) {
        int n;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeResource((Resources)context.getResources(), (int)drawableId, (BitmapFactory.Options)options);
        options.inSampleSize = n = ImageUtils.calculateInSampleSize(options, reqWidth, reqHeight);
        options.inJustDecodeBounds = false;
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)drawableId, (BitmapFactory.Options)options);
        return bitmap;
    }

    public static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int n = options.outHeight;
        int n2 = options.outWidth;
        int n3 = 1;
        if (n > reqHeight || n2 > reqWidth) {
            int n4;
            int n5 = Math.round((float)n / (float)reqHeight);
            n3 = n5 > (n4 = Math.round((float)n2 / (float)reqWidth)) ? n5 : n4;
        }
        return n3;
    }

    public static String getThumbnailImage(String imagePath, int thumbnailSize) {
        Bitmap bitmap = ImageUtils.decodeScaleImage(imagePath, thumbnailSize, thumbnailSize);
        try {
            File file = File.createTempFile("image", ".jpg");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            if (bitmap != null) {
                bitmap.compress(Bitmap.CompressFormat.JPEG, 60, (OutputStream)fileOutputStream);
            }
            fileOutputStream.close();
            EMLog.d("img", "generate thumbnail image at:" + file.getAbsolutePath() + " size:" + file.length());
            return file.getAbsolutePath();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return imagePath;
        }
    }

    public static String getFilename(Context context, String fileUri) {
        if (TextUtils.isEmpty((CharSequence)fileUri)) {
            return "";
        }
        if (!EMFileHelper.getInstance().isFileExist(context, Uri.parse((String)fileUri))) {
            return "";
        }
        return EMFileHelper.getInstance().getFilename(fileUri);
    }

    public static long getFileLength(Context context, String fileUri) {
        if (TextUtils.isEmpty((CharSequence)fileUri)) {
            return 0L;
        }
        return EMFileHelper.getInstance().getFileLength(fileUri);
    }

    public static String getScaledImageByUri(Context context, String localPath) {
        if (TextUtils.isEmpty((CharSequence)localPath)) {
            return localPath;
        }
        EMLog.d("img", "original localPath: " + localPath);
        Uri uri = Uri.parse((String)localPath);
        if (!EMFileHelper.getInstance().isFileExist(context, localPath)) {
            return localPath;
        }
        String string = EMFileHelper.getInstance().getFilePath(context, uri);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return ImageUtils.getScaledImage(context, string);
        }
        Uri uri2 = null;
        if (Build.VERSION.SDK_INT >= 24) {
            uri2 = ImageUtils.getScaledImage(context, uri);
        }
        return uri2 == null ? localPath : uri2.toString();
    }

    public static String getScaledImage(Context appContext, String imagePath) {
        File file = new File(imagePath);
        if (!file.exists()) {
            return imagePath;
        }
        long l = file.length();
        EMLog.d("img", "original img size:" + l);
        if (l <= 102400L) {
            EMLog.d("img", "use original small image");
            return imagePath;
        }
        Bitmap bitmap = ImageUtils.decodeScaleImage(imagePath, 640, 960);
        try {
            File file2 = File.createTempFile("image", ".jpg", appContext.getFilesDir());
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            if (bitmap != null) {
                bitmap.compress(Bitmap.CompressFormat.JPEG, 70, (OutputStream)fileOutputStream);
            }
            fileOutputStream.close();
            EMLog.d("img", "compared to small fle" + file2.getAbsolutePath() + " size:" + file2.length());
            return file2.getAbsolutePath();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return imagePath;
        }
    }

    @RequiresApi(api=24)
    public static Uri getScaledImage(Context appContext, Uri imageUri) {
        if (imageUri == null) {
            return imageUri;
        }
        try {
            long l = EMFileHelper.getInstance().getFileLength(imageUri);
            if (l <= 102400L) {
                EMLog.d("img", "use original small image");
                return imageUri;
            }
            Bitmap bitmap = ImageUtils.decodeScaleImage(appContext, imageUri, 640, 960);
            File file = File.createTempFile("image", ".jpg", appContext.getFilesDir());
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            if (bitmap != null) {
                bitmap.compress(Bitmap.CompressFormat.JPEG, 70, (OutputStream)fileOutputStream);
            }
            fileOutputStream.close();
            EMLog.d("img", "compared to small fle" + file.getAbsolutePath() + " size:" + file.length());
            return Uri.fromFile((File)file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static String getScaledImage(Context appContext, String imagePath, int i) {
        File file = new File(imagePath);
        if (file.exists()) {
            long l = file.length();
            EMLog.d("img", "original img size:" + l);
            if (l > 102400L) {
                Bitmap bitmap = ImageUtils.decodeScaleImage(imagePath, 640, 960);
                try {
                    File file2 = new File(appContext.getExternalCacheDir(), "eaemobTemp" + i + ".jpg");
                    FileOutputStream fileOutputStream = new FileOutputStream(file2);
                    if (bitmap != null) {
                        bitmap.compress(Bitmap.CompressFormat.JPEG, 60, (OutputStream)fileOutputStream);
                    }
                    fileOutputStream.close();
                    EMLog.d("img", "compared to small fle" + file2.getAbsolutePath() + " size:" + file2.length());
                    return file2.getAbsolutePath();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return imagePath;
    }

    public static Bitmap mergeImages(int targetWidth, int targetHeight, List<Bitmap> images) {
        Bitmap bitmap = Bitmap.createBitmap((int)targetWidth, (int)targetHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        canvas.drawColor(-3355444);
        EMLog.d("img", "merge images to size:" + targetWidth + "*" + targetHeight + " with images:" + images.size());
        int n = images.size() <= 4 ? 2 : 3;
        int n2 = 0;
        int n3 = (targetWidth - 4) / n;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                Bitmap bitmap2 = images.get(n2);
                Bitmap bitmap3 = Bitmap.createScaledBitmap((Bitmap)bitmap2, (int)n3, (int)n3, (boolean)true);
                Bitmap bitmap4 = ImageUtils.getRoundedCornerBitmap(bitmap3, 2.0f);
                bitmap3.recycle();
                canvas.drawBitmap(bitmap4, (float)(j * n3 + (j + 2)), (float)(i * n3 + (i + 2)), null);
                bitmap4.recycle();
                if (++n2 != images.size()) continue;
                return bitmap;
            }
        }
        return bitmap;
    }

    public static int readPictureDegree(String path) {
        int n = 0;
        try {
            ExifInterface exifInterface = new ExifInterface(path);
            int n2 = exifInterface.getAttributeInt("Orientation", 1);
            switch (n2) {
                case 6: {
                    n = 90;
                    break;
                }
                case 3: {
                    n = 180;
                    break;
                }
                case 8: {
                    n = 270;
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return n;
    }

    @RequiresApi(api=24)
    public static int readPictureDegree(Context context, Uri imageUri) {
        int n = 0;
        try {
            ParcelFileDescriptor parcelFileDescriptor = context.getContentResolver().openFileDescriptor(imageUri, "r");
            ExifInterface exifInterface = new ExifInterface(parcelFileDescriptor.getFileDescriptor());
            int n2 = exifInterface.getAttributeInt("Orientation", 1);
            switch (n2) {
                case 6: {
                    n = 90;
                    break;
                }
                case 3: {
                    n = 180;
                    break;
                }
                case 8: {
                    n = 270;
                }
            }
            parcelFileDescriptor.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return n;
    }

    public static Bitmap rotateImageView(int angle, Bitmap bitmap) {
        Matrix matrix = new Matrix();
        matrix.postRotate((float)angle);
        Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        return bitmap2;
    }

    public static BitmapFactory.Options getBitmapOptions(Context context, String fileUri) {
        if (TextUtils.isEmpty((CharSequence)fileUri)) {
            return null;
        }
        if (!EMFileHelper.getInstance().isFileExist(context, fileUri)) {
            return null;
        }
        String string = EMFileHelper.getInstance().getFilePath(context, fileUri);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return ImageUtils.getBitmapOptions(string);
        }
        try {
            return ImageUtils.getBitmapOptions(context, Uri.parse((String)fileUri));
        }
        catch (IOException iOException) {
            EMLog.e("img", "get bitmap options fail by " + iOException.getMessage());
            return null;
        }
    }

    public static BitmapFactory.Options getBitmapOptions(String imagePath) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)imagePath, (BitmapFactory.Options)options);
        ImageUtils.checkBitmapOrientation(ImageUtils.readPictureDegree(imagePath), options);
        return options;
    }

    public static BitmapFactory.Options getBitmapOptions(Context context, Uri uri) throws IOException {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        ParcelFileDescriptor parcelFileDescriptor = context.getContentResolver().openFileDescriptor(uri, "r");
        FileDescriptor fileDescriptor = parcelFileDescriptor.getFileDescriptor();
        BitmapFactory.decodeFileDescriptor((FileDescriptor)fileDescriptor, null, (BitmapFactory.Options)options);
        parcelFileDescriptor.close();
        if (Build.VERSION.SDK_INT >= 24) {
            ImageUtils.checkBitmapOrientation(ImageUtils.readPictureDegree(context, uri), options);
        }
        return options;
    }

    private static void checkBitmapOrientation(int degree, BitmapFactory.Options options) {
        if (degree == 90 || degree == 270) {
            int n = options.outHeight;
            options.outHeight = options.outWidth;
            options.outWidth = n;
        }
    }

    public static Bitmap getBitmapByUri(Context context, Uri uri, BitmapFactory.Options options) throws IOException {
        ParcelFileDescriptor parcelFileDescriptor = context.getContentResolver().openFileDescriptor(uri, "r");
        Bitmap bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)parcelFileDescriptor.getFileDescriptor(), null, (BitmapFactory.Options)options);
        parcelFileDescriptor.close();
        return bitmap;
    }
}

