/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipUtils {
    private static final int BUFF_SIZE = 0x100000;

    public static void zip(File folder, File zipFile) throws IOException {
        if (!folder.exists()) {
            return;
        }
        ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile), 0x100000));
        ZipUtils.zipFiles(folder, zipOutputStream, "");
        zipOutputStream.flush();
        zipOutputStream.close();
    }

    static void zipFiles(File file, ZipOutputStream zipOut, String dir) throws IOException {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                for (File file2 : fileArray) {
                    ZipUtils.zipFiles(file2, zipOut, dir + "\\" + file2.getName());
                }
            }
        } else {
            ZipUtils.zipFile(file, zipOut, dir);
        }
    }

    static void zipFile(File srcFile, ZipOutputStream zipOut, String dir) throws IOException {
        byte[] byArray = new byte[0x100000];
        BufferedInputStream bufferedInputStream = null;
        try {
            int n;
            bufferedInputStream = new BufferedInputStream(new FileInputStream(srcFile), 0x100000);
            String string = null;
            string = "".equals(dir) ? srcFile.getName() : dir + "\\" + srcFile.getName();
            zipOut.putNextEntry(new ZipEntry(dir));
            while ((n = bufferedInputStream.read(byArray)) != -1) {
                zipOut.write(byArray, 0, n);
            }
            zipOut.flush();
            zipOut.closeEntry();
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

