/*
 * Decompiled with CFR 0.152.
 */
package internal.com.getkeepsafe.relinker.elf;

import internal.com.getkeepsafe.relinker.elf.Dynamic32Structure;
import internal.com.getkeepsafe.relinker.elf.Elf;
import internal.com.getkeepsafe.relinker.elf.ElfParser;
import internal.com.getkeepsafe.relinker.elf.Program32Header;
import internal.com.getkeepsafe.relinker.elf.Section32Header;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class Elf32Header
extends Elf.Header {
    private final ElfParser parser;

    public Elf32Header(boolean bigEndian, ElfParser parser) throws IOException {
        this.bigEndian = bigEndian;
        this.parser = parser;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.order(bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
        this.type = parser.readHalf(byteBuffer, 16L);
        this.phoff = parser.readWord(byteBuffer, 28L);
        this.shoff = parser.readWord(byteBuffer, 32L);
        this.phentsize = parser.readHalf(byteBuffer, 42L);
        this.phnum = parser.readHalf(byteBuffer, 44L);
        this.shentsize = parser.readHalf(byteBuffer, 46L);
        this.shnum = parser.readHalf(byteBuffer, 48L);
        this.shstrndx = parser.readHalf(byteBuffer, 50L);
    }

    @Override
    public Elf.SectionHeader getSectionHeader(int index) throws IOException {
        return new Section32Header(this.parser, this, index);
    }

    @Override
    public Elf.ProgramHeader getProgramHeader(long index) throws IOException {
        return new Program32Header(this.parser, this, index);
    }

    @Override
    public Elf.DynamicStructure getDynamicStructure(long baseOffset, int index) throws IOException {
        return new Dynamic32Structure(this.parser, this, baseOffset, index);
    }
}

